/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class DoubleConfigOption
extends ConfigOption
implements Serializable {
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;

    public DoubleConfigOption(String optName, String optDesc, Double defValue) {
        super(optName, optDesc, defValue == null ? null : defValue.toString());
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        double val;
        try {
            val = Double.parseDouble(value);
        }
        catch (NumberFormatException exc) {
            throw this.invalidOption("must be an integer or double");
        }
        if (val < this.getMinValue()) {
            throw this.invalidOption("must be >= " + this.getMinValue());
        }
        if (val > this.getMaxValue()) {
            throw this.invalidOption("must be <= " + this.getMaxValue());
        }
    }

    public void setMinValue(double len) {
        this.minValue = len;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double len) {
        this.maxValue = len;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

