/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.InvalidOptionValueException;

public class IntegerConfigOption
extends ConfigOption
implements Serializable {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerConfigOption(String optName, String optDesc, Integer defValue) {
        super(optName, optDesc, defValue == null ? null : defValue.toString());
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        int val;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException exc) {
            throw this.invalidOption("must be an integer");
        }
        if (val < this.getMinValue()) {
            throw this.invalidOption("must be >= " + this.getMinValue() + " was [" + val + "]");
        }
        if (val > this.getMaxValue()) {
            throw this.invalidOption("must be <= " + this.getMaxValue() + " was [" + val + "]");
        }
    }

    public void setMinValue(int len) {
        this.minValue = len;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int len) {
        this.maxValue = len;
    }

    public int getMaxValue() {
        return this.maxValue;
    }
}

