/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.collection.IntHashMap;
import org.hyperic.util.file.WritableFile;

public class FileUtil {
    private static IntHashMap invalidChars = null;
    public static final int BUFSIZ = 2048;

    private FileUtil() {
    }

    public static WritableFile findWritableFile(File preferredDir, String filename, String[] alternateDirs, String alternatePrefixDir) throws IllegalArgumentException {
        File tempfile = new File(preferredDir, filename);
        preferredDir = tempfile.getParentFile();
        filename = tempfile.getName();
        if (alternateDirs == null) {
            alternateDirs = new String[]{System.getProperty("java.io.tmpdir"), System.getProperty("user.home") + File.separator + "tmp", System.getProperty("user.tmp"), System.getProperty("user.dir")};
        }
        if (!preferredDir.isDirectory()) {
            throw new IllegalArgumentException("preferredDir is not a directory: " + preferredDir);
        }
        alternateDirs = (String[])ArrayUtil.combine(new String[]{preferredDir.getAbsolutePath()}, alternateDirs);
        for (int i = 0; i < alternateDirs.length; ++i) {
            if (alternateDirs[i] == null) continue;
            WritableFile fileAttempt = alternatePrefixDir == null || i == 0 ? new WritableFile(alternateDirs[i], filename) : new WritableFile(alternateDirs[i], alternatePrefixDir + File.separator + filename);
            File dirToTest = fileAttempt;
            if (!dirToTest.isDirectory()) {
                dirToTest = dirToTest.getParentFile();
            }
            while (dirToTest != null && !dirToTest.exists()) {
                dirToTest = dirToTest.getParentFile();
            }
            if (dirToTest == null || !dirToTest.exists() || !dirToTest.canWrite()) continue;
            fileAttempt.setOriginalLocationWasUsed(i == 0);
            return fileAttempt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(inFile));
            os = new BufferedOutputStream(new FileOutputStream(outFile));
            FileUtil.copyStream(is, os);
        }
        catch (Throwable throwable) {
            FileUtil.safeCloseStream(is);
            FileUtil.safeCloseStream(os);
            throw throwable;
        }
        FileUtil.safeCloseStream(is);
        FileUtil.safeCloseStream(os);
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        FileUtil.copyStream(is, os, new byte[2048]);
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buf) throws IOException {
        int bytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            os.write(buf, 0, bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findString(String fname, String toFind) throws IOException {
        StringBuffer result = null;
        BufferedReader in = new BufferedReader(new FileReader(fname));
        try {
            int numread;
            char[] data = new char[8096];
            int toFindIndex = 0;
            char lastchar = 'a';
            while ((numread = in.read(data, 0, 8096)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (toFindIndex >= toFind.length() || data[i] == toFind.charAt(toFindIndex)) {
                        if (result == null) {
                            result = new StringBuffer();
                        }
                        if (Character.isISOControl(data[i])) {
                            String string = result.toString();
                            return string;
                        }
                        result.append(data[i]);
                        ++toFindIndex;
                    } else if (toFindIndex > 0) {
                        if (data[i] != lastchar) {
                            result = null;
                            toFindIndex = 0;
                            continue;
                        }
                        --toFindIndex;
                        --i;
                        result.deleteCharAt(result.length() - 1);
                        continue;
                    }
                    lastchar = data[i];
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getRelativePath(File path, File base) {
        String base_abs;
        String path_abs = path.getAbsolutePath();
        int idx = path_abs.indexOf(base_abs = base.getAbsolutePath());
        if (idx == -1) {
            throw new IllegalArgumentException("Path (" + path_abs + ") " + "does not contain " + "base (" + base_abs + ")");
        }
        String relativePath = "." + path_abs.substring(idx + base_abs.length());
        return relativePath;
    }

    private static void initInvalidChars() {
        if (invalidChars != null) {
            return;
        }
        invalidChars = new IntHashMap();
        char[] invalid = new char[]{'\\', '/', ':', '*', '?', '\'', '\"', '~', '<', '>', '|', '#', '{', '}', '%', '&', ' '};
        for (int i = 0; i < invalid.length; ++i) {
            invalidChars.put(invalid[i], Boolean.TRUE);
        }
    }

    public static String escape(String name) {
        FileUtil.initInvalidChars();
        int len = name.length();
        StringBuffer buf = new StringBuffer(len);
        char[] chars = name.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (invalidChars.get(c) == Boolean.TRUE) {
                buf.append("_");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("hyperic", null, dir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public static void setReadWriteOnlyByOwner(File file) throws IOException {
        String path = file.getAbsolutePath();
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return;
        }
        Runtime.getRuntime().exec("chmod 600 " + path);
    }

    public static String getParentDir(String path) {
        int idx = path.lastIndexOf(File.separator);
        if (idx == -1 || idx == 0) {
            throw new IllegalArgumentException("Path has no parent: " + path);
        }
        return path.substring(0, idx);
    }

    public static String getParentDir(String path, int levels) {
        while (levels-- > 0) {
            path = FileUtil.getParentDir(path);
        }
        return path;
    }

    public static List<String> readLines(InputStream is) throws IOException {
        String s;
        ArrayList<String> res = new ArrayList<String>();
        InputStreamReader isR = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isR);
        while ((s = br.readLine()) != null) {
            res.add(s);
        }
        return res;
    }

    public static boolean makeDirs(File dir, int numTries) throws InterruptedException {
        if (numTries < 1) {
            throw new IllegalArgumentException("number of tries must be greater than zero");
        }
        int tries = 0;
        while (tries++ < numTries) {
            boolean result = dir.mkdirs();
            if (result) {
                return true;
            }
            if (dir.exists()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void decompress(File compressedFile, File destination) throws IOException {
        if (compressedFile.getName().endsWith(".zip")) {
            FileUtil.unzip(compressedFile, destination);
        } else if (compressedFile.getName().endsWith(".tgz") || compressedFile.getName().endsWith(".tar.gz")) {
            FileUtil.untar(compressedFile, destination);
        } else {
            throw new IllegalArgumentException("Invalid file format; must be one of zip, tgz, or tar.gz.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void untar(File tarFile, File destinationDir) throws IOException {
        FileInputStream fileStream = null;
        GZIPInputStream gZipInputStream = null;
        TarInputStream tarInputStream = null;
        try {
            fileStream = new FileInputStream(tarFile);
            gZipInputStream = new GZIPInputStream(fileStream);
            tarInputStream = new TarInputStream((InputStream)gZipInputStream);
            TarEntry tarEntry = tarInputStream.getNextEntry();
            while (tarEntry != null) {
                File destPath = new File(destinationDir, tarEntry.getName());
                File parent = destPath.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    FileOutputStream fout = null;
                    try {
                        if (destPath.exists()) {
                            destPath.delete();
                        }
                        fout = new FileOutputStream(destPath);
                        tarInputStream.copyEntryContents((OutputStream)fout);
                    }
                    catch (Throwable throwable) {
                        FileUtil.safeCloseStream(fout);
                        throw throwable;
                    }
                    FileUtil.safeCloseStream(fout);
                }
                tarEntry = tarInputStream.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeCloseStream(fileStream);
            FileUtil.safeCloseStream(gZipInputStream);
            FileUtil.safeCloseStream(tarInputStream);
            throw throwable;
        }
        FileUtil.safeCloseStream(fileStream);
        FileUtil.safeCloseStream(gZipInputStream);
        FileUtil.safeCloseStream((InputStream)tarInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(File tarFile, File destinationDir) throws IOException {
        ZipInputStream zis = null;
        int BUFFER = 2048;
        try {
            zis = new ZipInputStream(new FileInputStream(tarFile));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File destPath = new File(destinationDir, zipEntry.getName());
                File parent = destPath.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                if (zipEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    byte[] data = new byte[2048];
                    FileOutputStream fout = null;
                    BufferedOutputStream bos = null;
                    try {
                        int count;
                        if (destPath.exists()) {
                            destPath.delete();
                        }
                        fout = new FileOutputStream(destPath);
                        bos = new BufferedOutputStream(fout, 2048);
                        while ((count = zis.read(data, 0, 2048)) != -1) {
                            bos.write(data, 0, count);
                        }
                        bos.flush();
                    }
                    catch (Throwable throwable) {
                        FileUtil.safeCloseStream(bos);
                        throw throwable;
                    }
                    FileUtil.safeCloseStream(bos);
                }
                zipEntry = zis.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeCloseStream(zis);
            throw throwable;
        }
        FileUtil.safeCloseStream(zis);
    }

    public static void safeCloseStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeCloseStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean safeFileMove(File moveFrom, File moveTo) {
        if (moveFrom.isDirectory()) {
            throw new IllegalArgumentException("moveFrom is a directory " + moveFrom);
        }
        if (moveTo.isDirectory()) {
            throw new IllegalArgumentException("moveTo is a directory " + moveTo);
        }
        boolean success = moveFrom.renameTo(moveTo);
        if (!success) {
            moveTo.delete();
            success = moveFrom.renameTo(moveTo);
        }
        return success;
    }

    public static final void persistObject(Serializable obj, String destDir, String fileName) throws Throwable {
        FileUtil.persistObject(obj, new File(destDir + File.separator + fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void persistObject(Serializable obj, File destFile) throws Throwable {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
        }
        finally {
            if (oos != null) {
                oos.flush();
                fos.getFD().sync();
                oos.close();
            } else if (null != fos) {
                fos.close();
            }
        }
    }
}

