/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.filter;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.types.FilterSet;

public class TokenReplacerFilterReader
extends FilterReader {
    private static final String DEFAULT_TOKEN_BEGIN = "${";
    private static final String DEFAULT_TOKEN_END = "}";
    private static final int DEFAULT_BUFSIZ = 8192;
    private FilterSet filter;
    private PushbackReader reader;
    private String buffer;
    private int index;

    public TokenReplacerFilterReader(Reader r) {
        super(r);
        this.reader = new PushbackReader(r, 8192);
        this.buffer = null;
        this.index = 0;
        this.filter = new FilterSet();
        this.filter.setBeginToken(DEFAULT_TOKEN_BEGIN);
        this.filter.setEndToken(DEFAULT_TOKEN_END);
    }

    public TokenReplacerFilterReader(String s) {
        this(new StringReader(s));
    }

    public void setBeginToken(String token) {
        this.filter.setBeginToken(token);
    }

    public void setEndToken(String token) {
        this.filter.setEndToken(token);
    }

    public void addFilter(String name, String value) {
        this.filter.addFilter(name, value);
    }

    public void addFilters(Map filters) {
        Set keys = filters.keySet();
        for (String key : keys) {
            this.filter.addFilter(key, filters.get(key).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            if (!this.refreshBuffer()) {
                return -1;
            }
            return this.buffer.charAt(this.index++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        int i;
        if (len > buf.length) {
            throw new IllegalArgumentException("buffer not large enough");
        }
        Reader reader = this.in;
        synchronized (reader) {
            for (i = 0; i < len; ++i) {
                if (!this.refreshBuffer()) {
                    return i == 0 ? -1 : i;
                }
                buf[offset + i] = this.buffer.charAt(this.index++);
            }
        }
        return i;
    }

    private boolean refreshBuffer() throws IOException {
        if (this.buffer == null || this.index >= this.buffer.length()) {
            int lastEndToken;
            char[] tmp = new char[8192];
            int size = this.reader.read(tmp, 0, 8192);
            if (size == -1) {
                return false;
            }
            String tmpStr = new String(tmp, 0, size);
            int lastBeginToken = tmpStr.lastIndexOf(this.filter.getBeginToken());
            if (lastBeginToken != -1 && (lastEndToken = tmpStr.indexOf(this.filter.getEndToken(), lastBeginToken)) == -1) {
                String toPush = tmpStr.substring(lastBeginToken);
                tmpStr = tmpStr.substring(0, lastBeginToken);
                this.reader.unread(toPush.toCharArray());
            }
            this.buffer = this.filter.replaceTokens(tmpStr);
            this.index = 0;
        }
        return true;
    }
}

