/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.hyperic.util.http.AgentRequest;
import org.hyperic.util.http.CommunicationConfiguration;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.Server;
import org.hyperic.util.timer.StopWatch;

public class ServersManager {
    private static final String SERVICE_UNAVAILABLE = "Service Unavailable";
    private static final Log logger = LogFactory.getLog(ServersManager.class);
    private List<Server> servers = new ArrayList<Server>();
    private Server alternateServer = null;
    private Server preferredServer = null;
    private boolean isGlobalDown = false;
    private long globalDownPeriod;
    private StopWatch globalDownPeriodWatch;
    private CommunicationConfiguration config = null;
    private HQHttpClient client = null;

    public ServersManager(HQHttpClient client, CommunicationConfiguration communicationConfiguration) {
        this.config = communicationConfiguration;
        logger.info((Object)communicationConfiguration);
        this.client = client;
        this.globalDownPeriodWatch = new StopWatch();
    }

    private List<Server> buildServers(String url) throws UnknownHostException, MalformedURLException {
        URL notResolvedUrl = new URL(url);
        String hostname = notResolvedUrl.getHost();
        InetAddress[] addresses = InetAddress.getAllByName(hostname);
        if (addresses == null || addresses.length == 0) {
            throw new UnknownHostException(String.format("The host %d is not reachable", hostname));
        }
        List<Object> resolvedServers = new LinkedList();
        this.preferredServer = new Server(addresses[0], this.client, this.config);
        if (!this.config.isSupportRRDNS()) {
            logger.info((Object)"Agent does not support RRDNS");
            resolvedServers = Collections.emptyList();
        } else {
            logger.info((Object)"Agent support RRDNS");
            for (int i = 1; i < addresses.length; ++i) {
                resolvedServers.add(new Server(addresses[i], this.client, this.config));
            }
            Collections.shuffle(resolvedServers);
        }
        logger.info((Object)("Servers are : Preferred(" + this.preferredServer + ") - " + resolvedServers));
        return resolvedServers;
    }

    public synchronized HttpResponse send(AgentRequest request) throws IOException {
        if (this.preferredServer == null) {
            this.servers = this.buildServers(request.getUrl());
        }
        if (this.isGlobalDownOn()) {
            logger.info((Object)("Servers are in global down  - time elapsed (" + TimeUnit.MILLISECONDS.toMinutes(this.globalDownPeriodWatch.getElapsed()) + ")"));
            throw new IOException(SERVICE_UNAVAILABLE);
        }
        return this.sendToServer(request);
    }

    private boolean isGlobalDownOn() {
        if (!this.isGlobalDown) {
            return false;
        }
        if (this.globalDownPeriodWatch.getElapsed() < this.globalDownPeriod) {
            return true;
        }
        this.isGlobalDown = false;
        return false;
    }

    private HttpResponse sendToServer(AgentRequest request) throws IOException {
        HttpResponse response = null;
        if (this.preferredServer.isAvailable()) {
            response = this.preferredServer.send(request);
            this.alternateServer = null;
        } else if (this.alternateServer != null && this.alternateServer.isAvailable()) {
            response = this.alternateServer.send(request);
        } else if (!this.servers.isEmpty()) {
            response = this.findAlternateServerAndSend(request);
        } else {
            throw new IOException(SERVICE_UNAVAILABLE);
        }
        return response;
    }

    private HttpResponse findAlternateServerAndSend(AgentRequest request) throws IOException {
        this.alternateServer = null;
        IOException lastException = null;
        for (Server server : this.servers) {
            try {
                HttpResponse response = server.send(request);
                this.alternateServer = server;
                logger.info((Object)("Choose new alternate server " + this.alternateServer));
                return response;
            }
            catch (IOException e) {
                logger.info((Object)("Failed trying server " + server));
                lastException = e;
            }
        }
        logger.error((Object)"All Servers are not available");
        this.setGlobalDownOn();
        if (lastException != null) {
            throw lastException;
        }
        throw new IOException(SERVICE_UNAVAILABLE);
    }

    private void setGlobalDownOn() {
        this.globalDownPeriod = this.preferredServer.getDownPeriod();
        logger.error((Object)("Insert to Global down for a period of " + TimeUnit.MILLISECONDS.toMinutes(this.globalDownPeriod) + " minutes"));
        this.isGlobalDown = true;
        this.globalDownPeriodWatch.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpResponse sendTryAll(AgentRequest request) throws IOException {
        if (this.preferredServer == null) {
            this.servers = this.buildServers(request.getUrl());
            this.servers.add(0, this.preferredServer);
        }
        Server lastSuccessServer = null;
        int counter = 0;
        String lastError = request.getUrl() + " is not reachable";
        for (Server server : this.servers) {
            try {
                ++counter;
                HttpResponse response = server.send(request);
                lastSuccessServer = server;
                logger.info((Object)("Successfully sent to server " + lastSuccessServer));
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            catch (IOException e) {
                if (counter != this.servers.size()) continue;
                throw e;
            }
            finally {
                if (lastSuccessServer == null) continue;
                this.servers.remove(lastSuccessServer);
                this.servers.add(0, lastSuccessServer);
                lastSuccessServer = null;
            }
        }
        throw new IOException(lastError);
    }
}

