/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hyperic.util.ConfigPropertyException;
import org.hyperic.util.jdbc.DBUtil;
import org.hyperic.util.jdbc.SequenceRetrievalException;

public class IDGenerator {
    private int itsDBType = 0;
    private String itsSequenceName;
    private int itsSequenceInterval;
    private String itsTableName = null;
    private String itsAlterSQL = null;
    private String itsSelectSQL = null;
    private long itsLastKey = 1L;
    private long itsMaxKey = 1L;
    private String ctx = null;
    private boolean isInitialized = false;
    private DBUtil dbUtil;

    public IDGenerator(String ctx, String theSequenceName, int theSequenceInterval, DBUtil dbUtil) {
        this.ctx = ctx;
        this.itsSequenceName = theSequenceName;
        this.itsSequenceInterval = theSequenceInterval;
        this.itsTableName = IDGenerator.getTableName(this.itsSequenceName);
        this.isInitialized = false;
        this.dbUtil = dbUtil;
    }

    public synchronized long getNewID() throws ConfigPropertyException, SequenceRetrievalException, SQLException {
        if (!this.isInitialized) {
            this.init();
        }
        if (this.itsLastKey >= this.itsMaxKey) {
            this.getBatch();
        }
        return ++this.itsLastKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getBatch() throws SequenceRetrievalException, SQLException {
        Connection conn = null;
        PreparedStatement selectPS = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            selectPS = conn.prepareStatement(this.itsSelectSQL);
            rs = selectPS.executeQuery();
            if (rs == null || !rs.next()) {
                throw new SequenceRetrievalException("IDGenerator.getBatch: sequence failed to return a value: " + this.itsSequenceName);
            }
            this.itsLastKey = rs.getLong(1) - 1L;
            this.itsMaxKey = this.itsLastKey + (long)this.itsSequenceInterval;
            this.doAlterSequence(conn);
        }
        catch (Throwable throwable) {
            DBUtil.closeJDBCObjects(this.ctx, conn, selectPS, rs);
            throw throwable;
        }
        DBUtil.closeJDBCObjects(this.ctx, conn, selectPS, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAlterSequence(Connection conn) throws SQLException {
        PreparedStatement alterPS = null;
        ResultSet rs = null;
        try {
            switch (this.itsDBType) {
                case 1: 
                case 2: 
                case 11: {
                    this.itsAlterSQL = "SELECT setval ('" + this.itsSequenceName + "', " + this.itsMaxKey + ")";
                    alterPS = conn.prepareStatement(this.itsAlterSQL);
                    rs = alterPS.executeQuery();
                    return;
                }
                case 3: 
                case 4: 
                case 8: 
                case 10: {
                    alterPS = conn.prepareStatement(this.itsAlterSQL);
                    alterPS.executeUpdate();
                    return;
                }
            }
            return;
        }
        finally {
            DBUtil.closeResultSet(this.ctx, rs);
            DBUtil.closeStatement(this.ctx, alterPS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() throws ConfigPropertyException, SQLException {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.itsDBType = DBUtil.getDBType(conn);
        }
        finally {
            DBUtil.closeConnection(this.ctx, conn);
        }
        switch (this.itsDBType) {
            case 1: 
            case 2: 
            case 11: {
                this.itsAlterSQL = "SELECT setval ('" + this.itsSequenceName + "', " + this.itsMaxKey + ")";
                this.itsSelectSQL = "SELECT nextval('" + this.itsSequenceName + "'::text)";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                this.itsAlterSQL = "ALTER SEQUENCE " + this.itsSequenceName + " INCREMENT BY " + this.itsSequenceInterval;
                this.itsSelectSQL = "SELECT " + this.itsSequenceName + ".nextval from DUAL";
                break;
            }
            case 9: {
                this.itsAlterSQL = "ALTER TABLE " + this.itsTableName + " AUTO_INCREMENT = " + this.itsMaxKey;
                this.itsSelectSQL = "SELECT MAX(ID) + 1 FROM " + this.itsTableName;
            }
        }
    }

    private static String getTableName(String sequence) {
        String[] tokens = sequence.split("_");
        String sub = new String();
        for (int i = 0; i < tokens.length - 2; ++i) {
            sub = sub + tokens[i] + (i != tokens.length - 3 ? "_" : "");
        }
        return sub;
    }

    private Connection getConnection() throws SQLException {
        return this.dbUtil.getConnection();
    }
}

