/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.math;

public final class MathUtil {
    public static final Integer NEGATIVE_ONE = new Integer(-1);
    public static final Integer ZERO = new Integer(0);

    public static int gcd(int n, int m) {
        n = Math.abs(n);
        m = Math.abs(m);
        if (n == 0 && m == 0) {
            return 1;
        }
        if (n == m && n >= 1) {
            return n;
        }
        return m < n ? MathUtil.gcd(n - m, n) : MathUtil.gcd(n, m - n);
    }

    public static int lcm(int n, int m) {
        return m * (n / MathUtil.gcd(n, m));
    }

    public static boolean compare(Number n1, Number n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    public static long clamp(long val, long min, long max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int clamp(int val, int min, int max) {
        return (int)MathUtil.clamp((long)val, (long)min, (long)max);
    }
}

