/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.thread;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class ThreadWatchdog {
    private final Log _log = LogFactory.getLog(ThreadWatchdog.class);
    private ScheduledThreadPoolExecutor _executor;
    private ThreadFactory _tFact = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ThreadWatchdog");
        }
    };

    @PostConstruct
    public void initialize() {
        this._executor = new ScheduledThreadPoolExecutor(1, this._tFact);
    }

    @PreDestroy
    public final void destroy() {
        this._executor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterruptToken interruptMeIn(long delay, TimeUnit units, String targetMsg) {
        ScheduledFuture<?> f;
        Interruptor i = new Interruptor(Thread.currentThread(), targetMsg, delay + " " + (Object)((Object)units));
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this._executor;
        synchronized (scheduledThreadPoolExecutor) {
            f = this._executor.schedule(i, delay, units);
        }
        InterruptToken res = new InterruptToken(f);
        return res;
    }

    public void cancelInterrupt(InterruptToken t) {
        t._f.cancel(false);
    }

    private class Interruptor
    implements Runnable {
        private final Thread _target;
        private final String _targetMsg;
        private final String _timeMsg;

        public Interruptor(Thread target, String targetMsg, String timeMsg) {
            this._target = target;
            this._targetMsg = targetMsg;
            this._timeMsg = timeMsg;
        }

        @Override
        public void run() {
            ThreadWatchdog.this._log.warn((Object)("Interrupting thread [" + this._target + "] (" + this._targetMsg + ") it exceeded " + this._timeMsg));
            this._target.interrupt();
        }
    }

    public static class InterruptToken {
        private final Future _f;

        private InterruptToken(Future f) {
            this._f = f;
        }
    }
}

