/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.units.ApproxDurationFormatter;
import org.hyperic.util.units.BitRateFormatter;
import org.hyperic.util.units.BytesFormatter;
import org.hyperic.util.units.BytesToBitsFormatter;
import org.hyperic.util.units.CurrencyFormatter;
import org.hyperic.util.units.DateFormatter;
import org.hyperic.util.units.DurationFormatter;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.Formatter;
import org.hyperic.util.units.NoFormatter;
import org.hyperic.util.units.ParseSpecifics;
import org.hyperic.util.units.PercentFormatter;
import org.hyperic.util.units.PercentageFormatter;
import org.hyperic.util.units.UnitNumber;

public class UnitsFormat {
    private static final HashMap formatters = new HashMap();
    private static Log log;

    public static FormattedNumber format(UnitNumber val) {
        return UnitsFormat.format(val, Locale.getDefault());
    }

    public static FormattedNumber format(UnitNumber val, Locale locale) {
        return UnitsFormat.format(val, locale, null);
    }

    private static Formatter getFormatter(int unitType) {
        Formatter res = (Formatter)formatters.get(new Integer(unitType));
        if (res == null) {
            throw new IllegalStateException("Unhandled unit type: " + unitType);
        }
        return res;
    }

    public static FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        Formatter formatter = UnitsFormat.getFormatter(val.getUnits());
        FormattedNumber res = formatter.format(val, locale, specifics);
        if (log.isDebugEnabled()) {
            log.debug((Object)("format(" + val.getValue() + ") -> " + res));
        }
        return res;
    }

    public static FormattedNumber[] formatSame(double[] values, int unitType, int scale) {
        return UnitsFormat.formatSame(values, unitType, scale, Locale.getDefault());
    }

    public static FormattedNumber[] formatSame(double[] values, int unitType, int scale, Locale locale) {
        return UnitsFormat.formatSame(values, unitType, scale, locale, null);
    }

    public static FormattedNumber[] formatSame(double[] values, int unitType, int scale, Locale locale, FormatSpecifics specifics) {
        Formatter formatter = UnitsFormat.getFormatter(unitType);
        FormattedNumber[] res = formatter.formatSame(values, unitType, scale, locale, specifics);
        if (log.isDebugEnabled()) {
            int i;
            StringBuffer buf = new StringBuffer();
            buf.append("format({");
            for (i = 0; i < values.length; ++i) {
                buf.append(values[i]);
                if (i == values.length) continue;
                buf.append(", ");
            }
            buf.append("}) -> {");
            for (i = 0; i < res.length; ++i) {
                buf.append(res[i].toString());
                if (i == values.length) continue;
                buf.append(", ");
            }
            buf.append("}");
            log.debug((Object)buf.toString());
        }
        return res;
    }

    static BigDecimal getBaseValue(double value, int unitType, int scale) {
        return UnitsFormat.getFormatter(unitType).getBaseValue(value, scale);
    }

    static BigDecimal getScaledValue(BigDecimal baseValue, int unitType, int scale) {
        return UnitsFormat.getFormatter(unitType).getScaledValue(baseValue, scale);
    }

    public static UnitNumber parse(String value, int unitType) throws ParseException {
        return UnitsFormat.parse(value, unitType, null);
    }

    public static UnitNumber parse(String value, int unitType, ParseSpecifics specifics) throws ParseException {
        return UnitsFormat.parse(value, unitType, Locale.getDefault(), specifics);
    }

    public static UnitNumber parse(String value, int unitType, Locale locale, ParseSpecifics specifics) throws ParseException {
        Formatter formatter = UnitsFormat.getFormatter(unitType);
        return formatter.parse(value, locale, specifics);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            UnitNumber num = UnitsFormat.parse(args[i], 2);
            System.out.println("Raw = " + num.getBaseValue());
            System.out.println("Fmt = " + UnitsFormat.format(num, Locale.getDefault()));
            System.out.println("Scaled to bytes = " + num.getScaledValue(0));
            System.out.println("Scaled to kilo = " + num.getScaledValue(1));
            System.out.println("Scaled to giga = " + num.getScaledValue(3));
        }
    }

    static {
        formatters.put(new Integer(0), new NoFormatter());
        formatters.put(new Integer(1), new CurrencyFormatter());
        formatters.put(new Integer(2), new BytesFormatter());
        formatters.put(new Integer(3), new BitRateFormatter());
        formatters.put(new Integer(9), new BytesToBitsFormatter());
        formatters.put(new Integer(4), new DurationFormatter());
        formatters.put(new Integer(5), new DateFormatter());
        formatters.put(new Integer(6), new PercentageFormatter());
        formatters.put(new Integer(7), new PercentFormatter());
        formatters.put(new Integer(8), new ApproxDurationFormatter());
        log = LogFactory.getLog(UnitsFormat.class);
    }
}

