/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.util.GenericValueMap;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class ConfigStorage {
    public static final String PROP_TYPE = "entity.type";
    public static final String PROP_ID = "entity.id";
    public static final String PROP_TYPE_NAME = "entity.typeName";
    public static final String CONFIG_PREFIX = "config.";
    public static final String NO_PREFIX = "";
    public static final String DOT_SEPARATOR = ".";
    private static Log log = LogFactory.getLog((String)ConfigStorage.class.getName());
    private AgentStorageProvider storage;
    private String keylistName;
    private String rootPrefix;

    public ConfigStorage(AgentStorageProvider storage, String keylistName, String storagePrefix) {
        this.storage = storage;
        this.keylistName = keylistName;
        this.rootPrefix = storagePrefix;
    }

    public Key getKey(AgentRemoteValue args) {
        return new Key(args.getValue(PROP_TYPE), args.getValue(PROP_ID), args.getValue(PROP_TYPE_NAME));
    }

    private String getKeys() {
        String keys = this.storage.getValue(this.keylistName);
        if (keys == null) {
            keys = NO_PREFIX;
        }
        return keys;
    }

    public Map<Key, ConfigResponse> load() {
        HashMap<Key, ConfigResponse> configs = new HashMap<Key, ConfigResponse>();
        StringTokenizer tok = new StringTokenizer(this.getKeys(), "|");
        while (tok.hasMoreTokens()) {
            Key key = new Key(tok.nextToken());
            ConfigResponse cr = new ConfigResponse();
            ConfigStorage.copy(key.storagePrefix, this.storage, NO_PREFIX, (GenericValueMap)cr);
            configs.put(key, cr);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Successfully restored config from storage: " + key + "-->" + cr));
        }
        return configs;
    }

    public ConfigResponse put(Key key, AgentRemoteValue args) throws AgentStorageException {
        ConfigResponse cr = new ConfigResponse();
        ConfigStorage.copy(CONFIG_PREFIX, args, NO_PREFIX, (GenericValueMap)cr);
        this.put(key, cr);
        return cr;
    }

    public void put(Key key, ConfigResponse cr) throws AgentStorageException {
        ConfigStorage.copy(NO_PREFIX, (GenericValueMap)cr, key.storagePrefix, this.storage);
        String keys = this.getKeys();
        String entry = key.getEntry();
        log.debug((Object)("Searching for '" + entry + "' " + "within '" + keys + "'"));
        if (keys.indexOf(entry) == -1) {
            keys = keys + entry;
            this.storage.setValue(this.keylistName, keys);
        }
        this.storage.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully stored config into storage: " + key + "-->" + cr));
        }
    }

    public void remove(Key key) throws AgentStorageException {
        String keys = this.getKeys();
        int len = keys.length();
        if (len == (keys = StringUtil.replace((String)keys, (String)key.getEntry(), (String)NO_PREFIX)).length()) {
            log.debug((Object)("Remove failed, key not found: " + key));
            return;
        }
        this.storage.setValue(this.keylistName, keys);
        Set<String> propertiesKeys = this.storage.getPropertiesKeys(key.getStoragePrefix());
        for (String propertiesKey : propertiesKeys) {
            this.storage.setValue(propertiesKey, null);
        }
        this.storage.flush();
        log.debug((Object)("Removed from storage: " + key));
    }

    public static GenericValueMap copy(String srcPrefix, GenericValueMap src, String destPrefix, GenericValueMap dest) {
        int srcPrefixLen = srcPrefix.length();
        ArrayList keys = new ArrayList();
        keys.addAll(src.getKeys());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (!key.startsWith(srcPrefix)) continue;
            String destKey = destPrefix + key.substring(srcPrefixLen);
            dest.setValue(destKey, src.getValue(key));
        }
        return dest;
    }

    public class Key {
        private static final String DELIM = "|";
        private int type;
        private int id;
        private String typeName;
        private String storagePrefix;
        private String key;
        private String appdefKey;

        private void init(String type, String id, String typeName) {
            this.init(Integer.parseInt(type), Integer.parseInt(id), typeName);
        }

        private void init(int type, int id, String typeName) {
            this.type = type;
            this.id = id;
            this.typeName = typeName;
            this.appdefKey = this.type + "-" + this.id + "-";
            this.key = this.appdefKey + this.typeName;
            this.storagePrefix = ConfigStorage.this.rootPrefix + ConfigStorage.DOT_SEPARATOR + this.key + ConfigStorage.DOT_SEPARATOR;
        }

        private Key(String type, String id, String typeName) {
            this.init(type, id, typeName);
        }

        private Key(String key) {
            String val = key;
            int ix = val.indexOf("-");
            if (ix == -1) {
                throw new IllegalArgumentException("Invalid key format: " + key);
            }
            String type = val.substring(0, ix);
            if ((ix = (val = val.substring(ix + 1)).indexOf("-")) == -1) {
                throw new IllegalArgumentException("Invalid key format: " + key);
            }
            String id = val.substring(0, ix);
            String typeName = val.substring(ix + 1);
            this.init(type, id, typeName);
        }

        private String getEntry() {
            return this.key + DELIM;
        }

        public int getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getStoragePrefix() {
            return this.storagePrefix;
        }

        public int hashCode() {
            return this.type * this.id * this.typeName.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return k.type == this.type && k.id == this.id && k.typeName.equals(this.typeName);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }
}

