/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.config.ConfigSchema;

public class Configuration_args
extends AgentRemoteValue {
    public static final String SCHEDULING_SEPERATOR = ".";
    public static final String RESOURCE_KIND_KEY = "id_resourceKind";
    public static final String RESOURCE_INTERNAL_ID_KEY = "id_resourceInternalId";
    public static final String MONITORED_RESOUCE_ID_KEY = "id_monitoresResourceId";
    public static final String PARENT_ID_KEY = "id_parentId";
    public static final String CONFIGUARTION_KEY_PREFIX = "config";
    public static final String SECURED_CONFIGUARTION_KEY_PREFIX = "secured.config";
    public static final String PROPERTIES_KEY_PREFIX = "prop";
    public static final String SCHEDULE_KEY_PREFIX = "schedule";
    public static final String IS_DELETE_RESOURCE = "isDelete";
    private int schedulingCounter = 0;

    public void setResourceKind(String resouceKind) {
        super.setValue(RESOURCE_KIND_KEY, resouceKind);
    }

    public String getResourceKind() {
        return this.getValue(RESOURCE_KIND_KEY);
    }

    public void setResourceInternalId(int internalId) {
        super.setValue(RESOURCE_INTERNAL_ID_KEY, Integer.toString(internalId));
    }

    public String getResourceInternalId() {
        return this.getValue(RESOURCE_INTERNAL_ID_KEY);
    }

    public void setParentId(String parentId) {
        super.setValue(PARENT_ID_KEY, parentId);
    }

    public String getParentId() {
        return this.getValue(PARENT_ID_KEY);
    }

    public void setMonitoredResourceId(String monitoredResourceId) {
        super.setValue(MONITORED_RESOUCE_ID_KEY, monitoredResourceId);
    }

    public String getMonitoredResourceId() {
        return this.getValue(MONITORED_RESOUCE_ID_KEY);
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.addEntriesWithKeyPrefix(CONFIGUARTION_KEY_PREFIX, configuration);
    }

    public Map<String, String> getConfiguration() {
        return this.getEntriesWithoutKeyPrefix(CONFIGUARTION_KEY_PREFIX);
    }

    public void setSecuredConfiguration(Map<String, String> securedConfiguration) {
        this.addEntriesWithKeyPrefix(SECURED_CONFIGUARTION_KEY_PREFIX, securedConfiguration);
    }

    public Map<String, String> getSecuredConfiguration() {
        return this.getEntriesWithoutKeyPrefix(SECURED_CONFIGUARTION_KEY_PREFIX);
    }

    public void setProperties(Map<String, String> configuration) {
        this.addEntriesWithKeyPrefix(PROPERTIES_KEY_PREFIX, configuration);
    }

    public Map<String, String> getProperties() {
        return this.getEntriesWithoutKeyPrefix(PROPERTIES_KEY_PREFIX);
    }

    public void addScheduling(String metricName, String metricId, String pollingInterval) {
        StringBuilder value = new StringBuilder();
        value.append(metricId).append(SCHEDULING_SEPERATOR);
        value.append(pollingInterval).append(SCHEDULING_SEPERATOR);
        value.append(metricName);
        super.setValue(SCHEDULE_KEY_PREFIX + this.schedulingCounter, value.toString());
        ++this.schedulingCounter;
    }

    public List<String[]> getSchedulings() {
        Map<String, String> schedulings = this.getScheduleEntries();
        if (schedulings == null || schedulings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String[]> parsedSchedulings = new ArrayList<String[]>(schedulings.size());
        for (String schedule : schedulings.values()) {
            parsedSchedulings.add(schedule.split("\\.", 3));
        }
        return parsedSchedulings;
    }

    private Map<String, String> getScheduleEntries() {
        return this.getEntriesWithoutKeyPrefix(SCHEDULE_KEY_PREFIX);
    }

    private void addEntriesWithKeyPrefix(String prefix, Map<String, String> entries) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            super.setValue(prefix + entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getEntriesWithoutKeyPrefix(String prefix) {
        Map<String, String> entries = this.getPrefixedValues(prefix);
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> withoutPrefix = new HashMap<String, String>(entries.size());
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            withoutPrefix.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return withoutPrefix;
    }

    private Map<String, String> getEntriesWithoutKeyPrefix() {
        Map<String, String> prefixlessEntries = this.getConfiguration();
        prefixlessEntries.putAll(this.getSecuredConfiguration());
        prefixlessEntries.putAll(this.getProperties());
        prefixlessEntries.putAll(this.getScheduleEntries());
        return prefixlessEntries;
    }

    @Override
    public void setValue(String key, String val) {
        throw new AgentAssertionException("This should never be called");
    }

    public void setIsDeleteResource(boolean deleteResource) {
        super.setValue(IS_DELETE_RESOURCE, String.valueOf(deleteResource));
    }

    public boolean isDeletedResource() {
        String val = super.getValue(IS_DELETE_RESOURCE);
        if (val != null) {
            return Boolean.valueOf(val);
        }
        return false;
    }

    @Override
    public String toString() {
        LinkedHashMap<String, String> safeVals = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getEntriesWithoutKeyPrefix().entrySet()) {
            if (ConfigSchema.isSecret((String)entry.getKey()) || ConfigSchema.isSensitive((String)entry.getKey())) {
                safeVals.put(entry.getKey(), "******");
                continue;
            }
            safeVals.put(entry.getKey(), entry.getValue());
        }
        return ((Object)safeVals).toString();
    }
}

