/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.shared;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.measurement.server.session.DataPoint;
import org.hyperic.hq.measurement.shared.MeasRange;
import org.hyperic.hq.measurement.shared.MeasTabManagerUtil;
import org.hyperic.util.TimeUtil;

public class MeasRangeObj {
    private static final String logCtx = MeasRangeObj.class.getName();
    private final Log _log = LogFactory.getLog((String)logCtx);
    private static MeasRangeObj _onlyInst = new MeasRangeObj();
    private List<MeasRange> _ranges = new ArrayList<MeasRange>();
    private List<MeasRange> _umRanges;

    private MeasRangeObj() {
        this.setRanges();
    }

    public static MeasRangeObj getInstance() {
        return _onlyInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRanges() {
        Calendar cal = Calendar.getInstance();
        long currTime = System.currentTimeMillis();
        String currTable = MeasTabManagerUtil.getMeasTabname(cal, currTime);
        currTime = MeasTabManagerUtil.getMeasTabStartTime(cal, currTime);
        String table = currTable;
        long max = MeasTabManagerUtil.getMeasTabEndTime(cal, currTime);
        MeasRange range = new MeasRange(currTable, currTime, max);
        List<MeasRange> list = this._ranges;
        synchronized (list) {
            do {
                this._log.debug((Object)("[setRanges] loading measurement range -> " + range));
                this._ranges.add(range);
                currTime = MeasTabManagerUtil.getPrevMeasTabTime(cal, currTime);
                max = MeasTabManagerUtil.getMeasTabEndTime(cal, currTime);
                currTime = MeasTabManagerUtil.getMeasTabStartTime(cal, currTime);
                table = MeasTabManagerUtil.getMeasTabname(cal, currTime);
                range = new MeasRange(table, currTime, max);
            } while (!currTable.equals(table));
            this._umRanges = Collections.unmodifiableList(this._ranges);
        }
    }

    public Map<String, Set<DataPoint>> bucketDataEliminateDups(List<DataPoint> data) {
        HashMap<String, Set<DataPoint>> buckets = new HashMap<String, Set<DataPoint>>();
        List<MeasRange> ranges = this.getRanges();
        for (DataPoint pt : data) {
            String table = this.getTable(ranges, pt.getMetricValue().getTimestamp());
            Set<DataPoint> dpts = buckets.get(table);
            if (null == dpts) {
                dpts = new HashSet<DataPoint>();
                buckets.put(table, dpts);
            }
            dpts.add(pt);
        }
        return buckets;
    }

    public Map<String, List<DataPoint>> bucketData(List<DataPoint> data) {
        HashMap<String, List<DataPoint>> buckets = new HashMap<String, List<DataPoint>>();
        List<MeasRange> ranges = this.getRanges();
        for (DataPoint pt : data) {
            String table = this.getTable(ranges, pt.getMetricValue().getTimestamp());
            List<DataPoint> dpts = buckets.get(table);
            if (null == dpts) {
                dpts = new ArrayList<DataPoint>();
                buckets.put(table, dpts);
            }
            dpts.add(pt);
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasRange> getRanges() {
        List<MeasRange> list = this._ranges;
        synchronized (list) {
            MeasRange latestRange = this._ranges.get(0);
            long now = System.currentTimeMillis();
            if (now > latestRange.getMaxTimestamp()) {
                this._ranges.remove(this._ranges.size() - 1);
                MeasRange latest = this.getCurrentRange();
                this._log.debug((Object)("[getRanges] loading measurement range -> " + latest));
                this._ranges.add(0, latest);
                this._umRanges = Collections.unmodifiableList(this._ranges);
            }
            return this._umRanges;
        }
    }

    public String getTable(long timestamp) {
        return this.getTable(this.getRanges(), timestamp);
    }

    public String getTable(List<MeasRange> ranges, long timestamp) {
        for (MeasRange range : ranges) {
            if (timestamp > range.getMaxTimestamp() || timestamp < range.getMinTimestamp()) continue;
            return range.getTable();
        }
        this._log.debug((Object)("Could not find an appropriate range for " + TimeUtil.toString((long)timestamp)));
        return MeasTabManagerUtil.getMeasTabname(timestamp);
    }

    private MeasRange getCurrentRange() {
        Calendar cal = Calendar.getInstance();
        long currTime = System.currentTimeMillis();
        String table = MeasTabManagerUtil.getMeasTabname(cal, currTime);
        long start = MeasTabManagerUtil.getMeasTabStartTime(cal, currTime);
        long end = MeasTabManagerUtil.getMeasTabEndTime(cal, currTime);
        return new MeasRange(table, start, end);
    }
}

