/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class NetConnectionData {
    private NetConnection _conn;
    private boolean _isNumericHosts;
    private boolean _isNumericPorts;
    private String _proto;
    private String _localPort;
    private String _remotePort;
    private int _maxLocalAddrLen = -1;
    private int _maxRemoteAddrLen = -1;
    private long _processPid = -1L;
    private String _processName;

    public NetConnectionData() {
    }

    public NetConnectionData(SigarProxy sigar, NetConnection conn, boolean isNumericHosts, boolean isNumericPorts) {
        this._conn = conn;
        this._isNumericHosts = isNumericHosts;
        this._isNumericPorts = isNumericPorts;
        this._proto = conn.getTypeString();
        this._localPort = this.getFormattedPort(sigar, conn.getType(), conn.getLocalPort());
        this._remotePort = this.getFormattedPort(sigar, conn.getType(), conn.getRemotePort());
    }

    public void setMaxLocalAddrLen(int len) {
        this._maxLocalAddrLen = len;
    }

    public void setMaxRemoteAddrLen(int len) {
        this._maxRemoteAddrLen = len;
    }

    public String getProtocol() {
        return this._proto;
    }

    public String getLocalPort() {
        return this._localPort;
    }

    public String getRemotePort() {
        return this._remotePort;
    }

    private String getFormattedPort(SigarProxy sigar, int proto, long port) {
        String service;
        if (port == 0L) {
            return "*";
        }
        if (!this._isNumericPorts && (service = sigar.getNetServicesName(proto, port)) != null) {
            return service;
        }
        return String.valueOf(port);
    }

    public String getFormattedAddress(String ip, String port, int max) {
        String address;
        if (NetFlags.isAnyAddress((String)ip)) {
            address = "*";
        } else if (this._isNumericHosts) {
            address = ip;
        } else {
            try {
                address = InetAddress.getByName(ip).getHostName();
            }
            catch (UnknownHostException e) {
                address = ip;
            }
        }
        if (max != -1 && address.length() > (max -= port.length() + 1)) {
            address = address.substring(0, max);
        }
        return address + ":" + port;
    }

    public String getFormattedLocalAddress() {
        return this.getFormattedAddress(this._conn.getLocalAddress(), this._localPort, this._maxLocalAddrLen);
    }

    public String getFormattedRemoteAddress() {
        return this.getFormattedAddress(this._conn.getRemoteAddress(), this._remotePort, this._maxRemoteAddrLen);
    }

    public String getFormattedState() {
        if (this._conn.getType() == 32) {
            return "";
        }
        return this._conn.getStateString();
    }

    public long getProcessPid() {
        return this._processPid;
    }

    public String getProcessName() {
        return this._processName;
    }

    public String getFormattedProcessName() {
        if (this._processPid == -1L) {
            return "";
        }
        return this._processPid + "/" + this._processName;
    }

    public void lookupProcessInfo(SigarProxy sigar) {
        if (this._conn.getState() != 10) {
            return;
        }
        try {
            long pid = sigar.getProcPort(this._conn.getType(), this._conn.getLocalPort());
            if (pid != 0L) {
                this._processPid = pid;
                this._processName = sigar.getProcState(pid).getName();
            }
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }
}

