/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hyperic.util.data.IComparableDatapoint;
import org.hyperic.util.data.IDisplayDataPoint;

public class MetricValue
implements IDisplayDataPoint,
IComparableDatapoint,
Serializable {
    private static final long serialVersionUID = 8322695266759550631L;
    private double _value;
    private long _timestamp;
    public static final double VALUE_NONE = Double.NaN;
    public static final MetricValue NONE = new MetricValue(Double.NaN);
    public static final double VALUE_FUTURE = Double.POSITIVE_INFINITY;
    public static final MetricValue FUTURE = new MetricValue(Double.POSITIVE_INFINITY);

    public MetricValue() {
    }

    public MetricValue(double value, long rtime) {
        this._timestamp = rtime;
        this._value = value;
    }

    public MetricValue(MetricValue src) {
        this._timestamp = src.getTimestamp();
        this._value = src.getValue();
    }

    public MetricValue(double value) {
        this(value, System.currentTimeMillis());
    }

    public MetricValue(Number objectValue, long rtime) {
        this(objectValue.doubleValue(), rtime);
    }

    public MetricValue(Number objectValue) {
        this(objectValue, System.currentTimeMillis());
    }

    public MetricValue(MetricValue objectValue, long rtime) {
        this(objectValue.getValue(), rtime);
    }

    public MetricValue(long value, long rtime) {
        this((double)value, rtime);
    }

    public MetricValue(long value) {
        this(value, System.currentTimeMillis());
    }

    public boolean isNone() {
        return Double.isNaN(this._value);
    }

    public boolean isFuture() {
        return Double.isInfinite(this._value);
    }

    public String toString() {
        if (this.isNone()) {
            return "None";
        }
        if (this.isFuture()) {
            return "Future";
        }
        NumberFormat nf = NumberFormat.getInstance();
        return nf.format(this._value);
    }

    public Double getObjectValue() {
        return new Double(this._value);
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double value) {
        this._value = value;
    }

    public void multiplyValue(double value) {
        this._value *= value;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long t) {
        this._timestamp = t;
    }

    public String getLabel() {
        return SimpleDateFormat.getDateTimeInstance().format(new Date(this.getTimestamp()));
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        MetricValue o2 = (MetricValue)o;
        double difference = this._value - o2._value;
        if (difference < 0.0) {
            return -1;
        }
        if (difference > 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MetricValue) {
            MetricValue val = (MetricValue)obj;
            return this.getTimestamp() == val.getTimestamp() && (this.getValue() == val.getValue() || Double.isNaN(this.getValue()) && Double.isNaN(val.getValue()));
        }
        return false;
    }
}

