/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hyperic.tools.db.InstantDBColumn;
import org.hyperic.tools.db.MySQLDBColumn;
import org.hyperic.tools.db.OracleColumn;
import org.hyperic.tools.db.PointbaseColumn;
import org.hyperic.tools.db.PostgresColumn;
import org.hyperic.tools.db.Table;
import org.hyperic.tools.db.TypeMap;
import org.hyperic.util.StrongList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Column {
    protected static final int DEFAULT_NONE = 0;
    protected static final int DEFAULT_AUTO_INCREMENT = 1;
    protected static final int DEFAULT_CURRENT_TIME = 2;
    protected static final int DEFAULT_SEQUENCE_ONLY = 3;
    private static final int DATABASE_TYPE = 0;
    protected String m_strName;
    protected String m_strType;
    protected String m_sReferences;
    protected int m_iSize;
    protected boolean m_bPrimaryKey;
    protected boolean m_bRequired;
    protected int m_iDefault;
    protected String m_sDefault;
    protected int m_iInitialSequence = 1;
    protected int m_iIncrementSequence = 1;
    protected String m_strTableName;

    protected Column(Node node, Table table) throws SAXException {
        if (Column.isColumn(node)) {
            NamedNodeMap map = node.getAttributes();
            for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                Node nodeMap = map.item(iAttr);
                String strName = nodeMap.getNodeName();
                String strValue = nodeMap.getNodeValue();
                if (strName.equalsIgnoreCase("name") || strName.equalsIgnoreCase("ref")) {
                    this.m_strName = strValue;
                } else if (strName.equalsIgnoreCase("type")) {
                    this.m_strType = strValue;
                } else if (strName.equalsIgnoreCase("size")) {
                    this.m_iSize = Integer.parseInt(strValue);
                } else if (strName.equalsIgnoreCase("primarykey")) {
                    this.m_bPrimaryKey = strValue.equalsIgnoreCase("true");
                } else if (strName.equalsIgnoreCase("required")) {
                    this.m_bRequired = strValue.equalsIgnoreCase("true");
                } else if (strName.equalsIgnoreCase("default")) {
                    if (strValue.equalsIgnoreCase("autoincrement")) {
                        this.m_iDefault = 1;
                    } else if (strValue.equalsIgnoreCase("sequence-only")) {
                        this.m_iDefault = 3;
                    } else if (strValue.equalsIgnoreCase("CURRENT_TIME") || strValue.equalsIgnoreCase("CURRENTTIME")) {
                        this.m_iDefault = 2;
                    } else {
                        this.m_sDefault = strValue;
                    }
                } else if (strName.equalsIgnoreCase("initial")) {
                    this.m_iInitialSequence = Integer.parseInt(strValue);
                } else if (strName.equalsIgnoreCase("references")) {
                    this.m_sReferences = strValue;
                } else if (strName.equalsIgnoreCase("increment")) {
                    this.m_iIncrementSequence = Integer.parseInt(strValue);
                } else {
                    System.out.println("Unknown attribute '" + nodeMap.getNodeName() + "' in tag 'table'");
                }
                this.m_strTableName = table.getName();
            }
        } else {
            throw new SAXException("node is not a Column.");
        }
    }

    protected Column(ResultSet set) throws SQLException {
        this.m_strName = set.getString(4);
        this.m_strType = set.getString(6);
        this.m_iSize = set.getInt(7);
        if (set.getInt(11) == 0) {
            this.m_bRequired = true;
        }
    }

    protected int getDefault() {
        return this.m_iDefault;
    }

    protected int getInitialSequence() {
        return this.m_iInitialSequence;
    }

    protected int getIncrementSequence() {
        return this.m_iIncrementSequence;
    }

    protected String getMappedType(Collection typemaps, int dbtype) {
        TypeMap map;
        Iterator iter = typemaps.iterator();
        String strResult = null;
        String strType = this.getType();
        while (iter.hasNext() && (strResult = (map = (TypeMap)iter.next()).getMappedType(strType, dbtype)) == null) {
        }
        if (strResult == null) {
            strResult = strType;
        }
        return strResult;
    }

    protected String getName() {
        return this.m_strName.toUpperCase();
    }

    protected String getType() {
        return this.m_strType;
    }

    protected int getSize() {
        return this.m_iSize;
    }

    protected boolean isPrimaryKey() {
        return this.m_bPrimaryKey;
    }

    protected boolean isRequired() {
        return this.m_bRequired;
    }

    protected String getReferences() {
        return this.m_sReferences;
    }

    protected String getsDefault() {
        return this.m_sDefault;
    }

    protected String getCreateCommand(List cmds, Collection typemaps, int dbtype) {
        String strDefault;
        String strCmd = this.getName() + ' ' + this.getMappedType(typemaps, dbtype);
        if (this.getSize() > 0) {
            strCmd = strCmd + this.getSizeCommand(cmds);
        }
        if (this.hasDefault() && (strDefault = this.getDefaultCommand(cmds)).length() > 0) {
            strCmd = strCmd + ' ' + strDefault;
        }
        if (this.m_sDefault != null) {
            strCmd = strCmd + " DEFAULT '" + this.getsDefault() + "'";
        }
        if (this.isRequired()) {
            strCmd = strCmd + " NOT NULL";
        }
        if (this.isPrimaryKey()) {
            strCmd = strCmd + " PRIMARY KEY";
        }
        if (this.m_sReferences != null) {
            strCmd = strCmd + " REFERENCES " + this.getReferences();
        }
        return strCmd;
    }

    protected static List getColumns(Node nodeTable, Table table, int dbtype) {
        NodeList listCols = nodeTable.getChildNodes();
        StrongList colResult = new StrongList("org.hyperic.tools.db.Column");
        for (int iCol = 0; iCol < listCols.getLength(); ++iCol) {
            Node node = listCols.item(iCol);
            if (!Column.isColumn(node)) continue;
            try {
                Column col = dbtype == OracleColumn.getClassType() ? new OracleColumn(node, table) : (dbtype == InstantDBColumn.getClassType() ? new InstantDBColumn(node, table) : (dbtype == PostgresColumn.getClassType() ? new PostgresColumn(node, table) : (dbtype == PointbaseColumn.getClassType() ? new PointbaseColumn(node, table) : (dbtype == MySQLDBColumn.getClassType() ? new MySQLDBColumn(node, table) : new Column(node, table)))));
                colResult.add(col);
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static List getColumns(DatabaseMetaData meta, Table table) throws SQLException {
        ResultSet setCols = meta.getColumns(null, null, table.getName(), null);
        StrongList colResult = new StrongList("org.hyperic.tools.db.Column");
        while (setCols.next()) {
            Column col = new Column(setCols);
            colResult.add(col);
        }
        return colResult;
    }

    protected static int getClassType() {
        return 0;
    }

    protected String getDefaultCommand(List cmds) {
        String strCmd = "DEFAULT ";
        switch (this.getDefault()) {
            case 1: {
                strCmd = strCmd + "AUTOINCREMENT";
                if (this.getInitialSequence() > 0) {
                    strCmd = strCmd + " INITIAL " + this.getInitialSequence();
                }
                if (this.getIncrementSequence() <= 0) break;
                strCmd = strCmd + " INCREMENT " + this.getIncrementSequence();
                break;
            }
            case 2: {
                strCmd = strCmd + "CURRENT_TIME";
            }
        }
        return strCmd;
    }

    protected String getSizeCommand(List cmds) {
        return "(" + this.getSize() + ')';
    }

    protected void getPreCreateCommands(List cmds) {
    }

    protected void getPostCreateCommands(List cmds) {
    }

    protected void getDropCommands(List cmds) {
    }

    protected boolean hasDefault() {
        return this.m_iDefault != 0;
    }

    protected static boolean isColumn(Node node) {
        return node.getNodeName().equalsIgnoreCase("column");
    }
}

