/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.hyperic.tools.db.SpeedTestThread;
import org.hyperic.util.jdbc.JDBC;

public class DBPing {
    private static final String COPYRIGHT = "\nDBPing, Copyright (C) 2002, Covalent Technologies, Inc., All Rights Reserved.\n";
    private static final String HELP = "DBPing database [username] [password] [-?] [-driver <driver class>][-op]\n                [-quiet][-speed [records]]\n  database   The JDBC connect string (e.g., jdbc:cloudscape:test;create=true)\n  -driver    The JDBC driver class for the database to connect to.\n             (e.g., COM.cloudscape.core.JDBCDriver).\n  -op        Runs an operation test to check that the database account has\n             privileges to create tables, create sequences, create triggers,\n             insert data, update data and delete data\n  -quiet     Doesn't display any messages\n  -speed     Runs a performance test on the database.\n             The test inserts and deletes database records. The default number\n             of records is 1000. The default can be overridden by following\n             this option with a space and the number of records to test with.\n  -threads   Specifies the number of treads to use for a speed test.\n  -?         Displays help\n  -help      Displays help";
    private static final int DEFAULT_NUMBER_SPEED_RECORDS = 1000;
    private boolean m_bQuiet;

    public static void main(String[] args) {
        boolean bResult;
        boolean bHelp;
        block28: {
            int iArgLen = args.length;
            String strDriverClassName = null;
            String strError = null;
            bHelp = false;
            boolean bOp = false;
            boolean bQuiet = false;
            bResult = false;
            boolean bSetNumRecs = false;
            boolean bSetNumThreads = false;
            boolean bSpeed = false;
            int iNumSpeedRecs = 1000;
            int iThreads = 0;
            for (int i = 0; i < iArgLen; ++i) {
                if (args[i].equals("-?") || args[i].equalsIgnoreCase("-help")) {
                    bHelp = true;
                    bQuiet = false;
                    break;
                }
                if (args[i].equalsIgnoreCase("-driver")) {
                    if (i + 1 < iArgLen) {
                        strDriverClassName = args[i + 1];
                        ++i;
                        continue;
                    }
                    strError = "A JDBC driver class name must be specified after the -driver option.";
                    bHelp = true;
                    break;
                }
                if (args[i].equalsIgnoreCase("-op")) {
                    bOp = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-quiet")) {
                    bQuiet = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-speed")) {
                    bSpeed = true;
                    if (i + 1 >= iArgLen || !Character.isDigit(args[i + 1].charAt(0))) continue;
                    iNumSpeedRecs = Integer.parseInt(args[i + 1]);
                    bSetNumRecs = true;
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-threads")) {
                    iThreads = 2;
                    if (i + 1 >= iArgLen || !Character.isDigit(args[i + 1].charAt(0))) continue;
                    iThreads = Integer.parseInt(args[i + 1]);
                    bSetNumThreads = true;
                    ++i;
                    continue;
                }
                if (args[i].charAt(0) != '-') continue;
                strError = "Unknown option '" + args[i] + '\'';
                bHelp = true;
                break;
            }
            if (bQuiet) {
                --iArgLen;
            }
            if (bSpeed) {
                --iArgLen;
                if (bSetNumRecs) {
                    --iArgLen;
                }
            }
            if (iThreads > 0) {
                --iArgLen;
                if (bSetNumThreads) {
                    --iArgLen;
                }
            }
            if (!bQuiet || bHelp) {
                System.out.println(COPYRIGHT);
                if (strError != null) {
                    System.out.println("Error : " + strError + '\n');
                }
            }
            if (!bHelp && iArgLen >= 1) {
                String strUsername = null;
                String strPassword = null;
                if (iArgLen >= 2) {
                    strUsername = args[1];
                }
                if (iArgLen >= 3) {
                    strPassword = args[2];
                }
                DBPing ping = new DBPing(bQuiet);
                try {
                    ping.ping(strDriverClassName, args[0], strUsername, strPassword);
                    if (bOp) {
                        if (!bQuiet) {
                            System.out.println();
                        }
                        ping.operationTest(strDriverClassName, args[0], strUsername, strPassword);
                    }
                    if (bSpeed) {
                        if (!bQuiet) {
                            System.out.println();
                        }
                        ping.speedTest(strDriverClassName, args[0], strUsername, strPassword, iNumSpeedRecs, iThreads);
                    }
                    break block28;
                }
                catch (SQLException e) {
                    if (!bQuiet) {
                        JDBC.printSQLException((SQLException)e);
                    }
                    break block28;
                }
                catch (Exception e) {
                    if (!bQuiet) {
                        System.out.println("Error: " + e);
                    }
                    break block28;
                }
            }
            bHelp = true;
        }
        if (bHelp) {
            System.out.println(HELP);
        }
        System.exit(bResult ? 0 : -1);
    }

    public DBPing() {
    }

    public DBPing(boolean quiet) {
        this.setQuiet(quiet);
    }

    public void operationTest(String database) throws ClassNotFoundException, SQLException {
        this.operationTest(null, database, null, null);
    }

    public void operationTest(String driver, String database) throws ClassNotFoundException, SQLException {
        this.operationTest(driver, database, null, null);
    }

    public void operationTest(String driver, String database, String username, String password) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        boolean bDropTable = false;
        boolean bDropSeq = false;
        Statement stmt = null;
        String strTableName = "DBPING_" + Math.abs(new Random().nextLong());
        String strSeqName = strTableName + "_SEQ";
        String strTest = "";
        this.println("Operation Test:");
        try {
            if (driver == null) {
                JDBC.loadDriver((String)database);
            }
            conn = DriverManager.getConnection(database, username, password);
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            String strCmd = "CREATE TABLE " + strTableName + " (ID INT, NAME CHAR(5))";
            strTest = "Create Table Test...";
            this.print("Create Table Test...");
            stmt.executeUpdate(strCmd);
            this.printSuccess();
            bDropTable = true;
            strCmd = "CREATE INDEX DBPING_INDEX ON " + strTableName + "(ID)";
            strTest = "Create Index Test...";
            this.print("Create Index Test...");
            stmt.executeUpdate(strCmd);
            this.printSuccess();
            int iDbType = JDBC.toType((String)database);
            if (iDbType == 3 || iDbType == 5) {
                strCmd = "CREATE SEQUENCE " + strSeqName;
                strTest = "Create Sequence Test...";
                this.print("Create Sequence Test...");
                stmt.executeUpdate(strCmd);
                bDropSeq = true;
                this.printSuccess();
                strCmd = "SELECT " + strSeqName + ".NEXTVAL FROM DUAL";
                strTest = "Query Sequence Test...";
                this.print("Query Sequence Test...");
                stmt.executeQuery(strCmd);
                this.printSuccess();
                strCmd = "CREATE TRIGGER " + strTableName + "_T " + "BEFORE INSERT ON " + strTableName + " " + "FOR EACH ROW " + "BEGIN " + "SELECT " + strSeqName + ".NEXTVAL FROM DUAL; " + "END;";
                strTest = "Create Trigger Test...";
                this.print("Create Trigger Test...");
                stmt.executeUpdate(strCmd);
                this.printSuccess();
                strCmd = "DROP TRIGGER " + strTableName + "_T";
                stmt.executeUpdate(strCmd);
            }
            strCmd = "INSERT INTO " + strTableName + " VALUES(1, 'Test1')";
            strTest = "Insert Test...";
            this.print("Insert Test...");
            stmt.executeUpdate(strCmd);
            this.printSuccess();
            strCmd = "SELECT ID FROM " + strTableName + " WHERE ID = 1";
            strTest = "Query Test...";
            this.print("Query Test...");
            stmt.executeQuery(strCmd);
            this.printSuccess();
            strCmd = "UPDATE " + strTableName + " SET NAME = 'Test2' WHERE ID = 1";
            strTest = "Update Test...";
            this.print("Update Test...");
            stmt.executeUpdate(strCmd);
            this.printSuccess();
            strCmd = "DELETE FROM " + strTableName + " WHERE ID = 1";
            strTest = "Delete Test...";
            this.print("Delete Test...");
            stmt.executeUpdate(strCmd);
            this.printSuccess();
        }
        catch (SQLException e) {
            SQLException ne;
            strTest = strTest.substring(0, strTest.indexOf(46));
            SQLException se = new SQLException(strTest + ": " + e.getMessage(), e.getSQLState(), e.getErrorCode());
            while ((ne = e.getNextException()) != null) {
                se.setNextException(ne);
            }
            throw se;
        }
        finally {
            if (bDropTable) {
                try {
                    stmt.executeUpdate("DROP TABLE " + strTableName);
                }
                catch (SQLException e) {}
            }
            if (bDropSeq) {
                try {
                    stmt.executeUpdate("DROP SEQUENCE " + strTableName + "_SEQ");
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public void ping(String database) throws ClassNotFoundException, SQLException {
        this.ping(null, database, null, null);
    }

    public void ping(String driver, String database) throws ClassNotFoundException, SQLException {
        this.ping(driver, database, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(String driver, String database, String username, String password) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        boolean bResult = true;
        this.println("Ping Test:");
        if (driver == null) {
            driver = JDBC.getDriverString((String)database);
        }
        database = JDBC.getConnectionString((String)driver, (String)database);
        try {
            Class.forName(driver);
            this.println("Successfully loaded the database driver.");
            conn = DriverManager.getConnection(database, username, password);
            this.println("Successfully connected to the database.");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public long speedTest(String driver, String database, String username, String password) throws ClassNotFoundException, SQLException {
        return this.speedTest(driver, database, username, password, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long speedTest(String driver, String database, String username, String password, int numrecs) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        boolean bDropTable = false;
        Statement stmt = null;
        String strTableName = "DBPING_" + Math.abs(new Random().nextLong());
        long lTotalElapsedTime = 0L;
        this.println("Speed Test:");
        try {
            if (driver == null) {
                JDBC.loadDriver((String)database);
            }
            conn = DriverManager.getConnection(database, username, password);
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            long lInsertStart = System.currentTimeMillis();
            String strCmd = "CREATE TABLE " + strTableName + " (ID INT PRIMARY KEY, NAME CHAR(30), ADDRESS1 CHAR(30), CITY CHAR(30), STATE CHAR(2), ZIP CHAR(5))";
            stmt.executeUpdate(strCmd);
            conn.commit();
            bDropTable = true;
            this.println("Created test table: " + strTableName);
            this.print("Running a database INSERT performance test...Inserting " + numrecs + " records...");
            for (int i = 1; i <= numrecs; ++i) {
                strCmd = Integer.toString(i);
                this.print(strCmd);
                for (int c = 0; c < strCmd.length(); ++c) {
                    this.print('\b');
                }
                stmt.executeUpdate("INSERT INTO " + strTableName + " VALUES(" + i + ", 'Mark Douglas', '645 Howard Street', 'San Francisco', 'CA', '94105')");
            }
            conn.commit();
            for (int c = 0; c < strCmd.length(); ++c) {
                this.print(' ');
            }
            this.println();
            long lInsertEnd = System.currentTimeMillis();
            long lInsertElapsed = (lInsertEnd - lInsertStart) / 1000L;
            this.print("Running a database DELETE performance test...Deleting " + numrecs + " records...");
            long lDeleteStart = System.currentTimeMillis();
            for (int i = 1; i <= numrecs; ++i) {
                strCmd = Integer.toString(i);
                this.print(strCmd);
                for (int c = 0; c < strCmd.length(); ++c) {
                    this.print('\b');
                }
                stmt.executeUpdate("DELETE FROM " + strTableName + " WHERE ID = " + i);
            }
            conn.commit();
            for (int c = 0; c < strCmd.length(); ++c) {
                this.print(' ');
            }
            this.println();
            stmt.executeUpdate("DROP TABLE " + strTableName);
            conn.commit();
            this.println("Dropped test table: " + strTableName);
            bDropTable = false;
            long lDeleteEnd = System.currentTimeMillis();
            long lDeleteElapsed = (lDeleteEnd - lDeleteStart) / 1000L;
            lTotalElapsedTime = lInsertElapsed + lDeleteElapsed;
            this.println();
            this.print("Insert Performance Time: ");
            this.printTime(lInsertElapsed);
            this.println();
            this.print("Delete Performance Time: ");
            this.printTime(lDeleteElapsed);
            this.println();
            this.print("Total Performance Time : ");
            this.printTime(lTotalElapsedTime);
            this.println();
        }
        finally {
            if (stmt != null && bDropTable) {
                try {
                    stmt.executeUpdate("DROP TABLE " + strTableName);
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return lTotalElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long speedTest(String driver, String database, String username, String password, int numrecs, int threads) throws ClassNotFoundException, SQLException {
        long lElapsed = 0L;
        if (threads == 0) {
            return this.speedTest(driver, database, username, password, numrecs);
        }
        Connection conn = null;
        boolean bDropTable = false;
        boolean bResult = false;
        Statement stmt = null;
        String strTableName = "DBPING_" + Math.abs(new Random().nextLong());
        this.println("Speed Test:");
        long lStart = System.currentTimeMillis();
        try {
            SpeedTestThread thread;
            int i;
            if (driver == null) {
                JDBC.loadDriver((String)database);
            }
            conn = DriverManager.getConnection(database, username, password);
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            String strCmd = "CREATE TABLE " + strTableName + " (ID INT PRIMARY KEY, NAME CHAR(30), ADDRESS1 CHAR(30), CITY CHAR(30), STATE CHAR(2), ZIP CHAR(5))";
            stmt.executeUpdate(strCmd);
            conn.commit();
            bDropTable = true;
            this.println("Created test table: " + strTableName);
            this.println("Running a database INSERT and DELETE performance test on " + numrecs + " records...");
            int iRecsPerThread = numrecs / threads;
            SpeedTestThread[] aThreads = new SpeedTestThread[threads];
            for (i = 0; i < threads; ++i) {
                thread = new SpeedTestThread(database, username, password, strTableName, iRecsPerThread * i + 1, iRecsPerThread * (i + 1));
                thread.setDaemon(true);
                thread.start();
                aThreads[i] = thread;
            }
            for (i = threads - 1; i >= 0; --i) {
                thread = aThreads[i];
                if (thread.isAlive()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        this.println("Error: " + e);
                    }
                }
                if (!(bResult = thread.getResult())) break;
            }
            stmt.executeUpdate("DROP TABLE " + strTableName);
            conn.commit();
            this.println("Dropped test table: " + strTableName);
            bDropTable = false;
            if (bResult) {
                lElapsed = (System.currentTimeMillis() - lStart) / 1000L;
                this.print("\nTotal Performance Time : ");
                this.printTime(lElapsed);
                this.println();
            }
        }
        finally {
            if (stmt != null && bDropTable) {
                try {
                    stmt.executeUpdate("DROP TABLE " + strTableName);
                }
                catch (SQLException e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return lElapsed;
    }

    public boolean isQuiet() {
        return this.m_bQuiet;
    }

    public void setQuiet(boolean quiet) {
        this.m_bQuiet = quiet;
    }

    protected void print(char c) {
        if (!this.isQuiet()) {
            System.out.print(c);
        }
    }

    protected void print(String s) {
        if (!this.isQuiet()) {
            System.out.print(s);
        }
    }

    protected void println() {
        if (!this.isQuiet()) {
            System.out.println();
        }
    }

    protected void println(String s) {
        if (!this.isQuiet()) {
            System.out.println(s);
        }
    }

    protected void printSuccess() {
        if (!this.isQuiet()) {
            System.out.println("Success");
        }
    }

    protected void printTime(long time) {
        long lMinutes = time / 60L;
        long lHours = lMinutes / 60L;
        lMinutes -= lHours * 60L;
        long lSeconds = time % 60L;
        if (lHours > 0L) {
            this.print(lHours + " hour");
            if (lHours > 1L) {
                this.print('s');
            }
            this.print(' ');
        }
        if (lMinutes > 0L) {
            this.print(lMinutes + " minutes ");
        }
        this.print(lSeconds + " seconds");
    }
}

