/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.file.monitor;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.springframework.roo.file.monitor.DirectoryMonitoringRequest;
import org.springframework.roo.file.monitor.FileMonitoringRequest;
import org.springframework.roo.file.monitor.MonitoringRequest;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.support.util.Assert;
import org.springframework.roo.support.util.StringUtils;

public class MonitoringRequestEditor
extends PropertyEditorSupport {
    public String getAsText() {
        DirectoryMonitoringRequest dmr;
        MonitoringRequest req = (MonitoringRequest)this.getValue();
        if (req == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(req.getFile().getCanonicalPath());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Failure retrieving path for request '" + req + "'", ioe);
        }
        sb.append(",");
        if (req.getNotifyOn().contains((Object)FileOperation.CREATED)) {
            sb.append("C");
        }
        if (req.getNotifyOn().contains((Object)FileOperation.RENAMED)) {
            sb.append("R");
        }
        if (req.getNotifyOn().contains((Object)FileOperation.UPDATED)) {
            sb.append("U");
        }
        if (req.getNotifyOn().contains((Object)FileOperation.DELETED)) {
            sb.append("D");
        }
        if (req instanceof DirectoryMonitoringRequest && (dmr = (DirectoryMonitoringRequest)req).isWatchSubtree()) {
            sb.append(",**");
        }
        return sb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] segments;
        if (text == null || "".equals(text)) {
            this.setValue(null);
        }
        if ((segments = StringUtils.commaDelimitedListToStringArray((String)text)).length < 2) {
            throw new IllegalArgumentException("Text '" + text + "' is invalid for a MonitoringRequest");
        }
        File file = new File(segments[0]);
        Assert.isTrue((boolean)file.exists(), (String)("File '" + file + "' does not exist"));
        HashSet<FileOperation> ops = new HashSet<FileOperation>();
        if (segments[1].contains("C")) {
            ops.add(FileOperation.CREATED);
        }
        if (segments[1].contains("R")) {
            ops.add(FileOperation.RENAMED);
        }
        if (segments[1].contains("U")) {
            ops.add(FileOperation.UPDATED);
        }
        if (segments[1].contains("D")) {
            ops.add(FileOperation.DELETED);
        }
        Assert.notEmpty(ops, (String)("One or more valid operation codes ('CRUD') required for file '" + file + "'"));
        if (file.isFile()) {
            Assert.isTrue((segments.length == 2 ? 1 : 0) != 0, (String)("Can only have two values for file '" + file + "'"));
            this.setValue(new FileMonitoringRequest(file, ops));
        } else if (segments.length == 3) {
            Assert.isTrue((boolean)"**".equals(segments[2]), (String)("The third value for directory '" + file + "' can only be '**' (or completely remove the third parameter if you do not want to watch the subtree)"));
            this.setValue(new DirectoryMonitoringRequest(file, true, ops));
        } else {
            this.setValue(new DirectoryMonitoringRequest(file, false, ops));
        }
    }
}

