/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import com.thoughtworks.xstream.XStream;
import org.hyperic.hq.plugin.system.DfData;
import org.hyperic.hq.plugin.system.IfconfigData;
import org.hyperic.hq.plugin.system.NetstatData;
import org.hyperic.hq.plugin.system.ProcessDetailData;
import org.hyperic.hq.plugin.system.ReadData;
import org.hyperic.hq.plugin.system.TimeData;
import org.hyperic.hq.plugin.system.TopData;
import org.hyperic.hq.product.LiveDataPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProcessControlPlugin;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.util.config.ConfigResponse;

public class SystemLiveDataPlugin
extends LiveDataPlugin {
    private static final int MAX_FILES = 500;
    public static final String PROP_PID = "process.pid";
    public static final String PROP_SIGNAL = "process.signal";
    public static final String PROP_NFILE = "read.numFiles";
    public static final String PROP_FILE = "read.file.";
    public static final String PROP_OFFSET = "read.offset.";
    public static final String PROP_NUMBYTES = "read.numBytes.";
    private static final String CMD_TIME = "time";
    private static final String CMD_READ = "read";
    private static final String CMD_CPUINFO = "cpuinfo";
    private static final String CMD_CPU = "cpu";
    private static final String CMD_CPUPERC = "cpuperc";
    private static final String CMD_DF = "df";
    private static final String CMD_TOP = "top";
    private static final String CMD_PROCESS = "process";
    private static final String CMD_KILL = "kill";
    private static final String CMD_NETSTAT = "netstat";
    private static final String CMD_IFCONFIG = "ifconfig";
    private static final String CMD_WHO = "who";
    private static final String[] _COMMANDS = new String[]{"time", "read", "cpuinfo", "cpu", "cpuperc", "df", "top", "process", "kill", "netstat", "ifconfig", "who"};
    private Sigar _sigarImpl;
    private Humidor _humidor;

    public void shutdown() throws PluginException {
        super.shutdown();
        if (this._sigarImpl != null) {
            this._sigarImpl.close();
            this._sigarImpl = null;
        }
    }

    private ReadData getReadData(String file, String sOffset, String sNumBytes) throws PluginException {
        int numBytes;
        long offset;
        if (file == null || sOffset == null || sNumBytes == null) {
            throw new PluginException("Must specify read.file., read.offset., read.numBytes.");
        }
        try {
            offset = Long.parseLong(sOffset);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Invalid offset: " + sOffset);
        }
        try {
            numBytes = Integer.parseInt(sNumBytes);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Invalid numBytes: " + sNumBytes);
        }
        return ReadData.gather(file, offset, numBytes);
    }

    private ReadData[] getReadData(ConfigResponse config) throws PluginException {
        int numFiles;
        String sNumFiles = config.getValue(PROP_NFILE);
        try {
            numFiles = Integer.parseInt(sNumFiles);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Invalid read.numFiles", (Throwable)e);
        }
        if (numFiles > 500) {
            throw new PluginException("Too many files.  Max=500");
        }
        ReadData[] res = new ReadData[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            String file = config.getValue(PROP_FILE + i);
            String sOffset = config.getValue(PROP_OFFSET + i);
            String sNumBytes = config.getValue(PROP_NUMBYTES + i);
            res[i] = this.getReadData(file, sOffset, sNumBytes);
        }
        return res;
    }

    private long getPid(ConfigResponse config) throws PluginException {
        String pid = config.getValue(PROP_PID);
        if (pid == null) {
            throw new PluginException("Missing process.pid");
        }
        try {
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            throw new PluginException("Invalid pid: " + pid);
        }
    }

    private synchronized SigarProxy getSigar() {
        if (this._humidor == null) {
            this._sigarImpl = new Sigar();
            this._humidor = new Humidor(this._sigarImpl);
        }
        return this._humidor.getSigar();
    }

    public Object getData(String command, ConfigResponse config) throws PluginException {
        SigarProxy sigar = this.getSigar();
        try {
            if (command.equals(CMD_TIME)) {
                return new TimeData(System.currentTimeMillis());
            }
            if (command.equals(CMD_READ)) {
                return this.getReadData(config);
            }
            if (command.equals(CMD_CPUINFO)) {
                return sigar.getCpuInfoList();
            }
            if (command.equals(CMD_CPU)) {
                return sigar.getCpuList();
            }
            if (command.equals(CMD_CPUPERC)) {
                return sigar.getCpuPercList();
            }
            if (command.equals(CMD_DF)) {
                return DfData.gather((SigarProxy)sigar);
            }
            if (command.equals(CMD_TOP)) {
                String filter = config.getValue("process.query");
                return TopData.gather((SigarProxy)sigar, (String)filter);
            }
            if (command.equals(CMD_PROCESS)) {
                return ProcessDetailData.gather(sigar, this.getPid(config));
            }
            if (command.equals(CMD_KILL)) {
                String signame = config.getValue(PROP_SIGNAL);
                if (signame == null) {
                    signame = "SIGKILL";
                }
                long pid = this.getPid(config);
                int signal = ProcessControlPlugin.getSignal((String)signame);
                this._sigarImpl.kill(pid, signal);
                return null;
            }
            if (command.equals(CMD_NETSTAT)) {
                NetstatData data = new NetstatData();
                String flags = config.getValue("netstat.flags");
                if (flags != null) {
                    data.setFlags(flags);
                }
                data.populate(sigar);
                return data;
            }
            if (command.equals(CMD_IFCONFIG)) {
                return IfconfigData.gather((SigarProxy)sigar);
            }
            if (command.equals(CMD_WHO)) {
                return sigar.getWhoList();
            }
            throw new PluginException("Unknown command '" + command + "'");
        }
        catch (SigarException e) {
            throw new PluginException("Error getting system data", (Throwable)e);
        }
    }

    public String[] getCommands() {
        return _COMMANDS;
    }

    public static void main(String[] args) throws Exception {
        SystemLiveDataPlugin p = new SystemLiveDataPlugin();
        ConfigResponse emtpy = new ConfigResponse();
        for (int i = 0; i < _COMMANDS.length; ++i) {
            System.out.println("Running command " + _COMMANDS[i]);
            Object o = p.getData(_COMMANDS[i], emtpy);
            XStream xstream = new XStream();
            System.out.println(xstream.toXML(o));
        }
    }
}

