/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ScriptLanguagePlugin;
import org.hyperic.util.PluginLoader;

public class GroovyLanguagePlugin
extends ProductPlugin
implements ScriptLanguagePlugin {
    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.addScriptLanguage(this);
    }

    public String getExtension() {
        return "groovy";
    }

    private void adjustClassPath(GroovyClassLoader cl) {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        if (parent instanceof PluginLoader) {
            PluginLoader loader = (PluginLoader)parent;
            URL[] urls = loader.getURLs();
            for (int i = 1; i < urls.length; ++i) {
                this.getLog().debug((Object)("Adding to classpath: " + urls[i]));
                cl.addURL(urls[i]);
            }
        }
    }

    public Class loadClass(ClassLoader loader, Properties properties, File file) throws PluginException {
        GroovyClassLoader cl = new GroovyClassLoader(loader);
        this.adjustClassPath(cl);
        try {
            cl.addURL(file.getParentFile().toURL());
            return cl.parseClass(file);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage(), (Throwable)e);
        }
    }
}

