/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.paramParser;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.util.TextIndenter;
import org.hyperic.util.paramParser.BasicRetriever;
import org.hyperic.util.paramParser.BlockHandler;
import org.hyperic.util.paramParser.ClassAtom;
import org.hyperic.util.paramParser.ContainerAtom;
import org.hyperic.util.paramParser.CriticalParseException;
import org.hyperic.util.paramParser.FormatAtom;
import org.hyperic.util.paramParser.FormatException;
import org.hyperic.util.paramParser.FormatParser;
import org.hyperic.util.paramParser.LiteralAtom;
import org.hyperic.util.paramParser.ParseException;
import org.hyperic.util.paramParser.ParseResult;
import org.hyperic.util.paramParser.ParserRetriever;
import org.hyperic.util.paramParser.StringParser;

public class ParamParser
implements BlockHandler {
    private ContainerAtom format;
    private ParserRetriever retriever;
    private BlockHandler blockHandler;

    public ParamParser(String formatText) {
        this.init(new BasicRetriever(), formatText, this);
    }

    public ParamParser(String formatText, BlockHandler blockHandler) {
        this.init(new BasicRetriever(), formatText, blockHandler);
    }

    public ParamParser(String formatText, ParserRetriever retriever, BlockHandler blockHandler) {
        this.init(retriever, formatText, blockHandler);
    }

    private void init(ParserRetriever retriever, String formatText, BlockHandler blockHandler) {
        this.retriever = retriever;
        char[] formatChars = formatText.toCharArray();
        this.format = this.parseFormat(formatChars, 0, formatChars.length);
        this.blockHandler = blockHandler;
        this.format.setRequired(true);
    }

    public ParseResult parseParams(String[] params) throws ParseException {
        ParseResult res = new ParseResult("**MAIN**");
        ArrayList processedElems = new ArrayList();
        if (this.parseAtom(res, processedElems, this.format, params, 0) != params.length) {
            throw new ParseException("All parameters not converted");
        }
        return res;
    }

    private int parseAtom(ParseResult res, List procList, FormatAtom atom, String[] params, int begIdx) throws ParseException {
        boolean isRequired = atom.isRequired();
        if (atom instanceof ContainerAtom && !((ContainerAtom)atom).isORed()) {
            ContainerAtom cAtom = (ContainerAtom)atom;
            ArrayList addList = new ArrayList();
            ParseResult contResult = new ParseResult(cAtom.getBlockName());
            res.addChild(contResult);
            int curIdx = begIdx;
            for (FormatAtom subAtom : cAtom.getSubAtoms()) {
                int nEaten;
                ArrayList subList = new ArrayList();
                try {
                    nEaten = this.parseAtom(contResult, subList, subAtom, params, curIdx);
                }
                catch (ParseException exc) {
                    if (isRequired) {
                        res.removeChild(contResult);
                        throw exc;
                    }
                    res.removeChild(contResult);
                    return 0;
                }
                curIdx += nEaten;
                addList.addAll(subList);
            }
            this.callBlockHandler(contResult, addList);
            procList.addAll(addList);
            return curIdx - begIdx;
        }
        if (atom instanceof ContainerAtom && ((ContainerAtom)atom).isORed()) {
            ContainerAtom cAtom = (ContainerAtom)atom;
            ParseException lastException = null;
            ParseResult contResult = new ParseResult(cAtom.getBlockName());
            res.addChild(contResult);
            for (FormatAtom subAtom : cAtom.getSubAtoms()) {
                int nEaten;
                ArrayList subList = new ArrayList();
                try {
                    nEaten = this.parseAtom(contResult, subList, subAtom, params, begIdx);
                }
                catch (CriticalParseException exc) {
                    throw exc;
                }
                catch (ParseException exc) {
                    lastException = exc;
                    continue;
                }
                this.callBlockHandler(contResult, subList);
                procList.addAll(subList);
                return nEaten;
            }
            res.removeChild(contResult);
            if (isRequired) {
                throw new ParseException("| condition not met", lastException);
            }
            return 0;
        }
        if (atom instanceof LiteralAtom) {
            LiteralAtom lAtom = (LiteralAtom)atom;
            String literal = lAtom.getLiteral();
            if (begIdx >= params.length) {
                throw new ParseException("No params left to handle literal '" + literal + "'");
            }
            if (params[begIdx].equals(literal)) {
                procList.add(new StringParser(literal));
                return 1;
            }
            if (isRequired) {
                throw new ParseException("Required parameter '" + literal + "' not provided");
            }
            return 0;
        }
        if (atom instanceof ClassAtom) {
            ClassAtom cAtom = (ClassAtom)atom;
            if (begIdx >= params.length) {
                throw new ParseException("No params left to handle class '" + cAtom.getParser().getClass().getName() + "'");
            }
            FormatParser parser = cAtom.getParser();
            parser.parseValue(params[begIdx]);
            procList.add(parser);
            return 1;
        }
        throw new IllegalStateException("Unhandled atom type");
    }

    private void dumpAtom(TextIndenter tInd, FormatAtom atom, String txt) {
        boolean required = atom.isRequired();
        tInd.append(required ? "<" : "[");
        tInd.append(txt);
        tInd.append(required ? ">\n" : "]\n");
    }

    private void dumpFormat(TextIndenter tInd, ContainerAtom atom) {
        String containerStr = atom.getBlockName();
        containerStr = containerStr != null ? "Container:" + containerStr : "Container";
        this.dumpAtom(tInd, atom, containerStr);
        tInd.pushIndent();
        for (FormatAtom subAtom : atom.getSubAtoms()) {
            if (subAtom instanceof ContainerAtom) {
                this.dumpFormat(tInd, (ContainerAtom)subAtom);
                continue;
            }
            if (subAtom instanceof ClassAtom) {
                this.dumpAtom(tInd, subAtom, "class " + ((ClassAtom)subAtom).getParser().getClass().getName());
                continue;
            }
            if (!(subAtom instanceof LiteralAtom)) continue;
            this.dumpAtom(tInd, subAtom, "literal " + ((LiteralAtom)subAtom).getLiteral());
        }
        tInd.popIndent();
    }

    public void dumpFormat(PrintStream os) {
        TextIndenter tInd = new TextIndenter();
        this.dumpFormat(tInd, this.format);
        os.print(tInd.toString());
    }

    private int findClassNameEnd(char[] chars, int beginIdx, int endIdx) {
        boolean doStart = true;
        for (int i = beginIdx; i < endIdx; ++i) {
            if (doStart) {
                if (!Character.isJavaIdentifierStart(chars[i])) {
                    throw new FormatException("Invalid class identifier at index " + i);
                }
                doStart = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(chars[i]) || chars[i] == '.') continue;
            return i - 1;
        }
        return endIdx - 1;
    }

    private int findLiteralEnd(char[] chars, int beginIdx, int endIdx) {
        for (int i = beginIdx; i < endIdx; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            return i - 1;
        }
        return endIdx - 1;
    }

    private int findMatchingEnd(char[] chars, char startToken, char endToken, int beginIdx, int endIdx) {
        int depth = 0;
        for (int i = beginIdx; i < endIdx; ++i) {
            if (chars[i] == startToken) {
                ++depth;
            } else if (chars[i] == endToken) {
                --depth;
            }
            if (depth != 0) continue;
            return i;
        }
        return -1;
    }

    private int findBlockNameEnd(char[] chars, int beginIdx, int endIdx) {
        for (int i = beginIdx; i < endIdx; ++i) {
            if (Character.isLetterOrDigit(chars[i])) continue;
            return i - 1;
        }
        return endIdx - 1;
    }

    private ContainerAtom parseFormat(char[] formatChars, int start, int end) {
        ContainerAtom res = new ContainerAtom();
        res.setBlockName("**MAIN**");
        int i = start;
        while (i < end) {
            FormatAtom newAtom;
            int atomEnd;
            if (formatChars[i] == '<' || formatChars[i] == '[') {
                char begChar;
                char endChar = (begChar = formatChars[i]) == '<' ? (char)'>' : ']';
                atomEnd = this.findMatchingEnd(formatChars, begChar, endChar, i, end);
                if (atomEnd == -1) {
                    throw new FormatException("Could not find closing " + endChar + " to match " + begChar + " at index " + i);
                }
                String blockName = null;
                if (i + 1 < end && formatChars[i + 1] == '$') {
                    int blockNameEnd;
                    if ((blockNameEnd = this.findBlockNameEnd(formatChars, ++i + 1, atomEnd)) == -1) {
                        throw new FormatException("Could not find end of block name at index " + i);
                    }
                    blockName = new String(formatChars, i + 1, blockNameEnd - i);
                    i = blockNameEnd + 1;
                }
                newAtom = this.parseFormat(formatChars, i + 1, atomEnd);
                newAtom.setRequired(begChar == '<');
                if (blockName == null) {
                    blockName = "Block#" + System.identityHashCode(newAtom);
                }
                ((ContainerAtom)newAtom).setBlockName(blockName);
                res.addSubAtom(newAtom);
                i = atomEnd + 1;
                continue;
            }
            if (Character.isWhitespace(formatChars[i])) {
                ++i;
                continue;
            }
            if (formatChars[i] == '#') {
                atomEnd = this.findClassNameEnd(formatChars, i + 1, end);
                String className = new String(formatChars, i + 1, atomEnd - i);
                newAtom = new ClassAtom(this.retriever.getParser(className));
                newAtom.setRequired(true);
                res.addSubAtom(newAtom);
                i = atomEnd + 1;
                continue;
            }
            atomEnd = this.findLiteralEnd(formatChars, i, end) + 1;
            String literal = new String(formatChars, i, atomEnd - i);
            newAtom = new LiteralAtom(literal);
            newAtom.setRequired(true);
            res.addSubAtom(newAtom);
            i = atomEnd + 1;
        }
        return res;
    }

    private void callBlockHandler(ParseResult result, List blockData) {
        this.blockHandler.handleBlock(result, blockData.toArray(new FormatParser[0]));
    }

    @Override
    public void handleBlock(ParseResult resultBlock, FormatParser[] blockData) {
        System.out.println("Processing block '" + resultBlock.getBlockName() + "'");
        if (resultBlock.getBlockName().equals("TimeRange")) {
            resultBlock.getRoot().setValue("Foo", "DoinTimeRange");
        }
        for (int i = 0; i < blockData.length; ++i) {
            System.out.println("    " + blockData[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        String format = "<<-foo #Integer> | <-bar #String>> [$TimeRange <-from #PastDate> <-to #FutureDate> [-interval #Integer]]";
        ParamParser p = new ParamParser(format);
        p.dumpFormat(System.out);
        System.out.print(p.parseParams(args).toString());
    }
}

