/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;
import org.hyperic.util.config.IntegerConfigOption;
import org.hyperic.util.config.StringConfigOption;
import org.hyperic.util.exec.Execute;
import org.hyperic.util.exec.ExecuteStreamHandler;
import org.hyperic.util.exec.ExecuteWatchdog;
import org.hyperic.util.exec.PumpStreamHandler;

public abstract class ServerControlPlugin
extends ControlPlugin {
    public static final String PROP_PIDFILE = "pidfile";
    public static final String PROP_PROGRAM = "program";
    public static final String PROP_PROGRAMPREFIX = "prefix";
    private static final String PROGRAM_PREFIX = "";
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private String installPrefix = null;
    private String controlProgram = null;
    private String controlProgramPrefix = null;
    private String pidFile = null;
    private int backgroundWaitTime = 0;
    private Sigar sigar = null;
    private static final String BACKGROUND_SCRIPT = "background" + ServerControlPlugin.getScriptExtension();
    private int exitCode;

    public ServerControlPlugin() {
        this.setControlProgramPrefix(PROGRAM_PREFIX);
    }

    public String getInstallPrefix() {
        return this.installPrefix;
    }

    public void setInstallPrefix(String val) {
        this.installPrefix = val;
    }

    public String getControlProgram() {
        if (this.controlProgram == null) {
            return this.getTypeProperty("DEFAULT_PROGRAM");
        }
        return this.controlProgram;
    }

    public void setControlProgram(String val) {
        this.controlProgram = val;
    }

    public String getControlProgramPrefix() {
        return this.controlProgramPrefix;
    }

    public void setControlProgramPrefix(String val) {
        this.controlProgramPrefix = val;
    }

    public String getPidFile() {
        return this.pidFile;
    }

    public void setPidFile(String val) {
        this.pidFile = val;
    }

    protected boolean useSigar() {
        return false;
    }

    @Override
    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        String val = config.getValue("timeout");
        if (val != null) {
            this.setTimeout(val);
        }
        if ((val = config.getValue("installpath")) != null) {
            this.setInstallPrefix(val);
        }
        if ((val = config.getValue(PROP_PROGRAM)) != null) {
            this.setControlProgram(val);
        }
        if ((val = config.getValue(PROP_PROGRAMPREFIX)) != null) {
            try {
                this.setControlProgramPrefix(val);
            }
            catch (IllegalArgumentException e) {
                throw new PluginException("Unable to parse prefix arguments");
            }
        }
        if ((val = config.getValue(PROP_PIDFILE)) != null) {
            this.setPidFile(val);
        }
        if (this.useSigar()) {
            this.sigar = new Sigar();
        }
    }

    @Override
    public void shutdown() throws PluginException {
        super.shutdown();
        if (this.sigar != null) {
            this.sigar.close();
        }
    }

    protected void getServerConfigSchema(TypeInfo info, ConfigSchema schema, ConfigResponse response) {
        String controlProgramPrefix;
        String controlProgram;
        StringConfigOption opt;
        String pidFile;
        String fileSep = info.isWin32Platform() ? "\\" : "/";
        String entName = info.getName();
        String installPrefix = response.getValue("installpath", this.getInstallPrefix());
        if (installPrefix == null) {
            installPrefix = this.getDefaultInstallPath();
        }
        if ((pidFile = this.getPidFile()) != null) {
            opt = new StringConfigOption(PROP_PIDFILE, "Full path to " + entName + " pid file", installPrefix + fileSep + pidFile);
            schema.addOption((ConfigOption)opt);
        }
        if ((controlProgram = this.getControlProgram()) != null) {
            opt = new StringConfigOption(PROP_PROGRAM, "Full path to " + entName + " control program", installPrefix + fileSep + controlProgram);
            schema.addOption((ConfigOption)opt);
        }
        if ((controlProgramPrefix = this.getControlProgramPrefix()) != null) {
            opt = new StringConfigOption(PROP_PROGRAMPREFIX, "Prefix arguments to control program", controlProgramPrefix);
            opt.setOptional(true);
            schema.addOption((ConfigOption)opt);
        }
        IntegerConfigOption timeout = new IntegerConfigOption("timeout", "Timeout of control operations (in seconds)", new Integer(this.getTimeout()));
        schema.addOption((ConfigOption)timeout);
    }

    @Override
    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema = super.getConfigSchema(info, config);
        if (this.useConfigSchema(info)) {
            this.getServerConfigSchema(info, schema, config);
        }
        return schema;
    }

    protected boolean useConfigSchema(TypeInfo info) {
        return info.getType() == 2;
    }

    @Override
    protected boolean isRunning() {
        return this.isProcessRunning(this.getPidFile());
    }

    protected boolean isProcessRunning(int pid) {
        if (this.sigar == null) {
            return false;
        }
        try {
            ProcState ps = this.sigar.getProcState((long)pid);
            return true;
        }
        catch (SigarException sigarException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isProcessRunning(String pidFile) {
        int processId;
        String pid;
        if (pidFile == null) {
            return false;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(pidFile));
            pid = in.readLine();
        }
        catch (FileNotFoundException e) {
            String err = "Pid file: " + pidFile + " not found";
            this.getLog().debug((Object)err);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.getLog().info((Object)("Could not read pidFile=" + pidFile));
            boolean err = true;
            return err;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        try {
            processId = Integer.parseInt(pid);
        }
        catch (NumberFormatException e) {
            String err = "Failed to parse pid from pid file: " + pidFile;
            this.getLog().debug((Object)err);
            this.setMessage(err);
            return false;
        }
        return this.isProcessRunning(processId);
    }

    protected File getWorkingDirectory() {
        File file = new File(this.getControlProgram()).getParentFile();
        if (file == null || !file.isAbsolute()) {
            file = new File(this.installPrefix);
        }
        return file;
    }

    protected String getControlProgramDir() {
        return new File(this.getControlProgram()).getParent();
    }

    protected void validateControlProgram(String name) throws PluginException {
        String pgm = this.getControlProgram();
        File script = new File(pgm);
        if (!script.exists()) {
            String msg = name + " control program not found: " + pgm;
            throw new PluginException(msg);
        }
    }

    protected boolean isBackgroundCommand() {
        return false;
    }

    protected int getBackgroundWaitTime() {
        String time = this.getPluginProperty("CONTROL_WAIT_TIME");
        if (time != null) {
            return Integer.parseInt(time);
        }
        return this.backgroundWaitTime;
    }

    protected void setBackgroundWaitTime(int seconds) {
        this.backgroundWaitTime = seconds;
    }

    protected String[] getCommandArgs() {
        return new String[0];
    }

    protected String[] getCommandEnv() {
        return null;
    }

    protected int doCommand() {
        return this.doCommand(this.getControlProgram(), new String[0]);
    }

    protected int doCommand(String command) {
        if (command == null) {
            return this.doCommand();
        }
        return this.doCommand(new String[]{command});
    }

    protected int doCommand(String[] args) {
        return this.doCommand(this.getControlProgram(), args);
    }

    protected int doCommand(String program, String arg) {
        return this.doCommand(program, new String[]{arg});
    }

    private String[] combine(String[] a1, String[] a2) {
        return (String[])ArrayUtil.combine((Object[])a1, (Object[])a2);
    }

    protected int doCommand(String program, String[] params) {
        String exe;
        String prefix;
        ArrayList<String> args = new ArrayList<String>();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(this.getTimeoutMillis());
        this.output.reset();
        Execute ex = new Execute((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)this.output), watchdog);
        File wd = this.getWorkingDirectory();
        if (wd.exists()) {
            ex.setWorkingDirectory(wd);
        }
        if (this.isBackgroundCommand()) {
            File background;
            Properties props = this.getManager().getProperties();
            String cwd = System.getProperty("user.dir");
            String dir = PROGRAM_PREFIX;
            try {
                dir = props.getProperty(AgentConfig.PROP_INSTALLHOME[0]);
            }
            catch (NoClassDefFoundError e) {
                dir = props.getProperty("agent.install.home", cwd);
            }
            if (dir.equals(".")) {
                dir = cwd;
            }
            if (!(background = new File(dir, BACKGROUND_SCRIPT)).exists()) {
                File pdk = new File(ProductPluginManager.getPdkDir());
                if (!pdk.isAbsolute()) {
                    pdk = new File(new File(cwd), ProductPluginManager.getPdkDir());
                }
                background = new File(pdk, "../" + BACKGROUND_SCRIPT);
            }
            if (background.exists()) {
                try {
                    args.add(background.getCanonicalPath());
                }
                catch (IOException ex1) {
                    args.add(background.getAbsolutePath());
                    this.getLog().debug((Object)("Failed to get canonical path of " + background), (Throwable)ex1);
                }
            }
            this.getLog().info((Object)("background=" + background));
        }
        if ((prefix = this.getControlProgramPrefix()) != null && prefix.length() != 0) {
            try {
                String[] prefixArgs = StringUtil.explodeQuoted((String)this.getControlProgramPrefix());
                for (int i = 0; i < prefixArgs.length; ++i) {
                    args.add(prefixArgs[i]);
                }
            }
            catch (IllegalArgumentException e) {
                this.getLog().error((Object)("Unable to parse arguments: " + prefix));
            }
        }
        if (OperatingSystem.IS_WIN32 && (exe = Win32.findScriptExecutable((String)program)) != null) {
            args.add(exe);
        }
        if (new File(program).isAbsolute()) {
            args.add(program);
        } else {
            args.add(this.installPrefix + File.separator + program);
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                args.add(params[i]);
            }
        }
        String[] commandArgs = this.getCommandArgs();
        for (int i = 0; i < commandArgs.length; ++i) {
            if (commandArgs[i] == null) continue;
            args.add(commandArgs[i]);
        }
        this.getLog().info((Object)("doCommand args=" + args));
        ex.setCommandline(args.toArray(new String[0]));
        String[] env = new String[]{"HQ_CONTROL_RESOURCE=" + this.getName(), "HQ_CONTROL_TYPE=" + this.getTypeInfo().getName(), "HQ_CONTROL_WAIT=" + this.getBackgroundWaitTime()};
        env = this.combine(env, ex.getEnvironment());
        String[] cmdEnv = this.getCommandEnv();
        if (cmdEnv != null) {
            env = this.combine(env, cmdEnv);
        }
        ex.setEnvironment(env);
        this.exitCode = -1;
        try {
            this.exitCode = ex.execute();
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            this.setMessage(e.getMessage());
        }
        if (this.exitCode == 0) {
            this.setResult(0);
        } else {
            this.setResult(-1);
        }
        if (watchdog.killedProcess()) {
            String err = "Command did not complete within timeout of " + this.getTimeout() + " seconds";
            this.getLog().error((Object)err);
            this.setMessage(err);
            this.setResult(-1);
            return this.getResult();
        }
        this.getLog().info((Object)("doCommand result=" + this.getResult() + ", exitCode=" + this.exitCode));
        String message = this.output.toString();
        if (message.length() > 0) {
            this.setMessage(message);
        }
        return this.getResult();
    }

    protected int getExitCode() {
        return this.exitCode;
    }

    protected void handleResult(String stateWanted) {
        if (this.getResult() != 0) {
            if (this.getMessage() == null) {
                this.setMessage("Unknown Error (exit code=" + this.exitCode + ")");
            }
            return;
        }
        String state = this.waitForState(stateWanted);
        if (!state.equals(stateWanted)) {
            this.setResult(-1);
            if (this.getMessage() == null) {
                this.setMessage("Control action timed out after " + this.getTimeout() + " seconds.  Server still in state " + state);
            }
        }
    }

    protected int start(String command) {
        int res = this.doCommand(command);
        this.waitForState("started");
        return res;
    }
}

