/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.appdef.shared;

public class AIQueueConstants {
    public static final int Q_DECISION_DEFER = 0;
    public static final int Q_DECISION_APPROVE = 1;
    public static final int Q_DECISION_IGNORE = 2;
    public static final int Q_DECISION_UNIGNORE = 3;
    public static final int Q_DECISION_PURGE = 4;
    public static final String[] Q_DECISIONS = new String[]{"defer", "approve", "ignore", "unignore", "purge"};
    public static final int Q_STATUS_PLACEHOLDER = 0;
    public static final int Q_STATUS_ADDED = 1;
    public static final int Q_STATUS_CHANGED = 2;
    public static final int Q_STATUS_REMOVED = 3;
    public static final long Q_DIFF_NONE = 0L;
    public static final long Q_PLATFORM_FQDN_CHANGED = 2L;
    public static final long Q_PLATFORM_IPS_CHANGED = 4L;
    public static final long Q_PLATFORM_SERVERS_CHANGED = 8L;
    public static final long Q_PLATFORM_PROPERTIES_CHANGED = 16L;
    public static final long Q_IP_NETMASK_CHANGED = 1L;
    public static final long Q_IP_MAC_CHANGED = 2L;
    public static final long Q_SERVER_SERVICES_CHANGED = 1L;
    public static final long Q_SERVER_NAME_CHANGED = 2L;
    public static final long Q_SERVER_INSTALLPATH_CHANGED = 4L;
    public static final long Q_SERVER_CONFIG_CHANGED = 8L;

    public static String getQueueStatusString(int qstat) {
        switch (qstat) {
            case 0: {
                return "unchanged";
            }
            case 1: {
                return "new";
            }
            case 2: {
                return "modified";
            }
            case 3: {
                return "removed";
            }
        }
        return "unknown (error?)";
    }

    public static String getPlatformDiffString(int qstat, long diff) {
        String diffString = "";
        if (qstat == 1) {
            diffString = "N/A";
        } else {
            if ((diff & 2L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "fqdn changed";
            }
            if ((diff & 0x10L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "platform properties changed";
            }
            if ((diff & 4L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "IP set changed";
            }
            if ((diff & 8L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "server set changed";
            }
            if (diffString.length() == 0) {
                diffString = "none";
            }
        }
        return diffString;
    }

    public static String getIPDiffString(int qstat, long diff) {
        String diffString = "";
        if (qstat == 1) {
            diffString = "N/A";
        } else {
            if ((diff & 2L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "MAC changed";
            }
            if ((diff & 1L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "netmask changed";
            }
            if (diffString.length() == 0) {
                diffString = "none";
            }
        }
        return diffString;
    }

    public static String getServerDiffString(int qstat, long diff) {
        String diffString = "";
        if (qstat == 1) {
            diffString = "N/A";
        } else {
            if ((diff & 1L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "services changed";
            }
            if ((diff & 2L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "Name changed";
            }
            if ((diff & 4L) != 0L) {
                if (diffString.length() > 0) {
                    diffString = diffString + ", ";
                }
                diffString = diffString + "Installpath changed";
            }
            if (diffString.length() == 0) {
                diffString = "none";
            }
        }
        return diffString;
    }

    public static int getActionValue(String actionString) {
        for (int i = 0; i < Q_DECISIONS.length; ++i) {
            if (!Q_DECISIONS[i].equalsIgnoreCase(actionString)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid action: " + actionString);
    }

    public static boolean diffContains(long diff, long attr) {
        return (diff & attr) != 0L;
    }
}

