/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.FileServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;

public class DaemonDetector
extends ServerDetector
implements AutoServerDetector,
FileServerDetector {
    private static final Log log = LogFactory.getLog((String)DaemonDetector.class.getName());
    private ConfigResponse _platformConfig;

    protected String getProcessQuery() {
        String res = null;
        if (DaemonDetector.isWin32()) {
            res = this.getTypeProperty("WIN32_PROC_QUERY");
        }
        if (res == null) {
            res = this.getTypeProperty("PROC_QUERY");
        }
        return res;
    }

    protected boolean isSwitch(String arg) {
        return arg.startsWith("-");
    }

    private void addDefine(Map opts, String opt, int ix) {
        String key = opt.substring(2, ix);
        String val = opt.substring(ix + 1);
        opts.put(key, val);
        if (key.startsWith("hq.")) {
            key = StringUtil.replace((String)key.toUpperCase(), (String)".", (String)"_");
        } else if (!key.startsWith("HQ_")) {
            return;
        }
        opts.put(key.substring(3), val);
    }

    protected Map getProcOpts(long pid) {
        String[] args = DaemonDetector.getProcArgs(pid);
        int len = args.length;
        HashMap<String, String> opts = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            String val;
            String opt = args[i];
            if (!this.isSwitch(opt)) continue;
            int ix = opt.indexOf(61);
            if (ix != -1) {
                if (opt.startsWith("-D")) {
                    this.addDefine(opts, opt, ix);
                }
                val = opt.substring(ix + 1);
                opt = opt.substring(ix);
            } else {
                if (i + 1 >= len || this.isSwitch(val = args[i + 1])) continue;
                ++i;
            }
            opts.put(opt, val);
        }
        return opts;
    }

    protected void discoverServerConfig(ServerResource server, long pid) {
        String id;
        Map opts = this.getProcOpts(pid);
        boolean isDebug = log.isDebugEnabled();
        boolean hasOpts = false;
        ConfigResponse config = server.getProductConfig();
        if (config == null) {
            config = new ConfigResponse();
            this.setProductConfig(server, config);
        }
        for (String key : config.getKeys()) {
            String val;
            String opt = this.getTypeProperty(key + ".opt");
            if (opt == null || (val = (String)opts.get(opt)) == null) continue;
            config.setValue(key, val);
            hasOpts = true;
            if (!isDebug) continue;
            log.debug((Object)("Set " + key + "=" + val + ", using " + opt + " from pid=" + pid));
        }
        if (hasOpts) {
            server.setProductConfig(config);
        }
        ConfigResponse pconfig = this.getPlatformConfig();
        ConfigResponse sconfig = server.getProductConfig();
        ConfigResponse oconfig = new ConfigResponse(opts);
        String name = this.formatAutoInventoryName(server.getType(), pconfig, sconfig, oconfig);
        if (name != null) {
            server.setName(name);
        }
        if ((id = (String)opts.get("INVENTORY_ID")) == null) {
            id = server.getIdentifier();
        }
        server.setIdentifier(this.formatName(id, pconfig, sconfig, oconfig));
        String installpath = (String)opts.get("INSTALLPATH");
        if (installpath == null) {
            installpath = server.getInstallPath();
        }
        server.setInstallPath(this.formatName(installpath, pconfig, sconfig, oconfig));
    }

    protected ServerResource newServerResource(long pid, String exe) {
        ServerResource server = this.newServerResource(exe);
        this.discoverServerConfig(server, pid);
        return server;
    }

    protected ServerResource newServerResource(String exe) {
        ServerResource server = this.createServerResource(exe);
        this.setProductConfig(server, new ConfigResponse());
        this.setMeasurementConfig(server, new ConfigResponse());
        return server;
    }

    protected void setPlatformConfig(ConfigResponse config) {
        this._platformConfig = config;
    }

    protected ConfigResponse getPlatformConfig() {
        return this._platformConfig;
    }

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        this.setPlatformConfig(platformConfig);
        List servers = this.getFileResources(platformConfig);
        if (servers.size() != 0) {
            return servers;
        }
        List processes = this.getProcessResources(platformConfig);
        for (int i = 0; i < processes.size(); ++i) {
            ServerResource server = (ServerResource)processes.get(i);
            if (!this.isInstallTypeVersion(server.getInstallPath())) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    public List getServerResources(ConfigResponse platformConfig, String path) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        servers.add(this.newServerResource(path));
        return servers;
    }

    @Override
    protected List discoverServices(ConfigResponse config) throws PluginException {
        String hasBuiltinServices = this.getTypeProperty("HAS_BUILTIN_SERVICES");
        if (!"true".equals(hasBuiltinServices)) {
            return super.discoverServices(config);
        }
        ArrayList<ServiceResource> services = new ArrayList<ServiceResource>();
        TypeInfo[] types = this.data.getTypes();
        for (int i = 0; i < types.length; ++i) {
            TypeInfo type = types[i];
            if (type.getType() != 3 || !this.getTypeInfo().getVersion().equals(type.getVersion())) continue;
            ServiceResource service = new ServiceResource();
            service.setType(type.getName());
            String name = this.getTypeNameProperty(type.getName());
            service.setServiceName(name);
            this.setProductConfig(service, new ConfigResponse());
            this.setMeasurementConfig(service, new ConfigResponse());
            services.add(service);
        }
        return services;
    }

    protected List getFileResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String type = this.getTypeInfo().getName();
        List includes = this.data.getFileScanIncludes(type);
        if (includes == null) {
            return servers;
        }
        for (int i = 0; i < includes.size(); ++i) {
            String file = (String)includes.get(i);
            if (!new File(file).exists()) continue;
            servers.add(this.newServerResource(file));
        }
        return servers;
    }

    protected List getProcessResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<ServerResource> servers = new ArrayList<ServerResource>();
        String query = this.getProcessQuery();
        if (query == null) {
            log.debug((Object)("No PROC_QUERY defined for: " + this.getTypeInfo().getName()));
            return servers;
        }
        log.debug((Object)("Using PROC_QUERY=" + query + " for " + this.getTypeInfo().getName()));
        long[] pids = DaemonDetector.getPids(query);
        log.debug((Object)("'" + query + "' matched " + pids.length + " processes"));
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            String exe = DaemonDetector.getProcExe(pid);
            if (exe == null) {
                log.debug((Object)("Unable to determine exe for " + query + " pid=" + pid));
                exe = query;
            }
            servers.add(this.newServerResource(pid, exe));
        }
        return servers;
    }
}

