/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.hq.product.TrackEvent;

public class LogMessageFolder {
    static final int DEFAULT_REPEAT_WINDOW = 300000;
    static final int DEFAULT_REPEAT_MAX = 2;
    private static Log log = LogFactory.getLog((String)LogMessageFolder.class.getName());
    private Map _messages = new HashMap();
    private LogTrackPlugin _plugin;
    private long _window;
    private long _max;

    public LogMessageFolder(LogTrackPlugin plugin) {
        this._plugin = plugin;
        String window = this.getProperty("window");
        if (window == null) {
            window = this.getManagerProperty("track.interval");
        }
        if (window != null) {
            this.setRepeatWindow(Integer.parseInt(window) * 1000);
        } else {
            this.setRepeatWindow(300000L);
        }
        String max = this.getProperty("max");
        if (max != null) {
            this.setRepeatMax(Integer.parseInt(max));
        } else {
            this.setRepeatMax(2L);
        }
    }

    private void debug(String message) {
        String name = this._plugin.getTypeInfo().getName() + " (" + this._plugin.getName() + ") ";
        log.debug((Object)(name + message));
    }

    public long getRepeatMax() {
        return this._max;
    }

    public void setRepeatMax(long max) {
        this._max = max;
        if (log.isDebugEnabled()) {
            this.debug("configured repeat max=" + this._max);
        }
    }

    public long getRepeatWindow() {
        return this._window;
    }

    public void setRepeatWindow(long window) {
        this._window = window;
        if (log.isDebugEnabled()) {
            this.debug("configured repeat window=" + this._window + "ms");
        }
    }

    private String getManagerProperty(String key) {
        return this._plugin.getManager().getProperty(key);
    }

    private String getProperty(String key) {
        return this.getManagerProperty("track.repeat." + key);
    }

    public boolean shouldFold(TrackEvent event, List messages) {
        boolean shouldFold = false;
        for (int i = 0; i < messages.size(); ++i) {
            String message = (String)messages.get(i);
            if (!this.shouldFold(event, message)) continue;
            shouldFold = true;
        }
        return shouldFold;
    }

    public boolean shouldFold(TrackEvent event, String message) {
        long num = this.addMessage(event, message);
        return num > this._max;
    }

    private void reportRepeatMessage(MessageCounter counter, long time) {
        TrackEvent repeat = counter._event;
        String message = "Message '" + counter._message + "' repeated " + counter._number + " times";
        TrackEvent event = new TrackEvent(this._plugin.getName(), time, repeat.getLevel(), repeat.getSource(), message);
        this._plugin.getManager().reportEvent(event);
    }

    private boolean checkWindow(TrackEvent event, MessageCounter counter) {
        long now = System.currentTimeMillis();
        if (now - counter._timestamp > this._window && counter._number > this._max) {
            this.reportRepeatMessage(counter, now);
            counter._number = 0L;
            counter._timestamp = now;
            counter._event = event;
            return true;
        }
        return false;
    }

    public long addMessage(TrackEvent event, String message) {
        MessageCounter counter = (MessageCounter)this._messages.get(message);
        if (counter == null) {
            counter = new MessageCounter(message);
            counter._event = event;
            this._messages.put(message, counter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating counter for message=" + message));
            }
        } else {
            this.checkWindow(event, counter);
        }
        return ++counter._number;
    }

    private class MessageCounter {
        private String _message;
        private TrackEvent _event;
        private long _number = 0L;
        private long _timestamp = System.currentTimeMillis();

        private MessageCounter(String message) {
            this._message = message;
        }
    }
}

