/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.snmp;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.snmp.SNMPException;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SNMPValue {
    private static Log log = LogFactory.getLog(SNMPValue.class);
    public static final int TYPE_LONG = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_LONG_CONVERTABLE = 2;
    OID oid;
    Variable var;

    private SNMPValue() {
    }

    SNMPValue(VariableBinding vb) {
        this(vb.getOid(), vb.getVariable());
    }

    SNMPValue(OID oid, Variable var) {
        this.oid = oid;
        this.var = var;
    }

    private boolean isOctetString() {
        return this.var.getSyntax() == 4;
    }

    public byte[] getBytes() {
        return ((OctetString)this.var).getValue();
    }

    public String toString() {
        if (this.isOctetString()) {
            return new String(this.getBytes());
        }
        return this.var.toString();
    }

    private String toHex(int val) {
        return Integer.toHexString(val & 0xFF);
    }

    public String toPhysAddressString() {
        byte[] data = this.getBytes();
        if (data.length == 0) {
            return "0:0:0:0:0:0";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toHex(data[0]));
        for (int i = 1; i < data.length; ++i) {
            buffer.append(':').append(this.toHex(data[i]));
        }
        return buffer.toString();
    }

    public String getOID() {
        return this.oid.toString();
    }

    public int getType() {
        switch (this.var.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: 
            case 70: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return 1;
    }

    private long convertDateAndTimeToLong() throws SNMPException {
        byte[] bytes = this.getBytes();
        if (bytes.length < 8) {
            String msg = "OctetString is not in DateAndTime syntax";
            throw new SNMPException(msg);
        }
        Calendar cal = Calendar.getInstance();
        int ix = 0;
        int year = bytes[ix] > 0 ? bytes[ix] : 256 + bytes[ix];
        year <<= 8;
        year += bytes[++ix] > 0 ? bytes[ix] : 256 + bytes[ix];
        int n = ++ix;
        byte month = bytes[n];
        int n2 = ++ix;
        byte day = bytes[n2];
        int n3 = ++ix;
        byte hour = bytes[n3];
        int n4 = ++ix;
        byte minutes = bytes[n4];
        int n5 = ++ix;
        byte seconds = bytes[n5];
        int n6 = ++ix;
        ++ix;
        byte deciseconds = bytes[n6];
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 100 * deciseconds);
        cal.set(15, 0);
        cal.set(16, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("converted to DateAndTime: millis=" + cal.getTimeInMillis() + ", date=" + cal.getTime()));
        }
        return cal.getTimeInMillis();
    }

    public long toLong() throws SNMPException {
        if (this.isOctetString()) {
            return this.convertDateAndTimeToLong();
        }
        try {
            return this.var.toLong();
        }
        catch (UnsupportedOperationException e) {
            String msg = "Cannot convert " + this.var.getSyntaxString() + " to long";
            throw new SNMPException(msg);
        }
    }
}

