/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.appdef.shared;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.hyperic.hq.appdef.shared.AppdefEntityConstants;
import org.hyperic.hq.appdef.shared.InvalidAppdefTypeException;
import org.hyperic.hq.authz.shared.AuthzConstants;
import org.hyperic.util.StringUtil;

public class AppdefEntityID
implements Serializable {
    private static final long serialVersionUID = -8149143799228813017L;
    private int entityType;
    private int entityID;
    private int _entityType;
    private int _entityID;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.entityType != 0) {
            this._entityType = this.entityType;
            this.entityType = 0;
        }
        if (this.entityID != 0) {
            this._entityID = this.entityID;
            this.entityID = 0;
        }
    }

    public AppdefEntityID(String id) {
        try {
            if (id == null) {
                throw new InvalidAppdefTypeException("Invalid entity type: " + id);
            }
            List typeList = StringUtil.explode((String)id, (String)":");
            if (typeList.size() != 2) {
                throw new InvalidAppdefTypeException("Invalid entity type: " + id);
            }
            this._entityType = new Integer((String)typeList.get(0));
            this._entityID = new Integer((String)typeList.get(1));
        }
        catch (NumberFormatException e) {
            throw new InvalidAppdefTypeException("Invalid entity type: " + id);
        }
        if (!AppdefEntityConstants.typeIsValid(this._entityType)) {
            throw new InvalidAppdefTypeException("Invalid entity type: " + this._entityType);
        }
    }

    public AppdefEntityID(int entityType, int entityID) {
        this._entityType = entityType;
        this._entityID = entityID;
        if (!AppdefEntityConstants.typeIsValid(entityType)) {
            throw new IllegalArgumentException("Invalid entity type: " + entityType);
        }
    }

    public AppdefEntityID(int entityType, Integer entityID) {
        this(entityType, (int)entityID);
    }

    public int getType() {
        return this._entityType;
    }

    public String getTypeName() {
        return AppdefEntityConstants.typeToString(this._entityType);
    }

    public int getID() {
        return this._entityID;
    }

    public Integer getId() {
        return new Integer(this._entityID);
    }

    public String getAppdefKey() {
        return this._entityType + ":" + this._entityID;
    }

    public String getAuthzTypeName() {
        switch (this.getType()) {
            case 1: {
                return "covalentEAMPlatform";
            }
            case 2: {
                return "covalentEAMServer";
            }
            case 3: {
                return "covalentEAMService";
            }
            case 4: {
                return "covalentEAMApplication";
            }
            case 5: {
                return "covalentAuthzResourceGroup";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + this.getType());
    }

    public Integer getAuthzTypeId() {
        switch (this.getType()) {
            case 1: {
                return AuthzConstants.authzPlatform;
            }
            case 2: {
                return AuthzConstants.authzServer;
            }
            case 3: {
                return AuthzConstants.authzService;
            }
            case 4: {
                return AuthzConstants.authzApplication;
            }
            case 5: {
                return AuthzConstants.authzGroup;
            }
            case 10: {
                return AuthzConstants.authzPolicy;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + this.getType());
    }

    public boolean isPlatform() {
        return this.getType() == 1;
    }

    public boolean isServer() {
        return this.getType() == 2;
    }

    public boolean isService() {
        return this.getType() == 3;
    }

    public boolean isApplication() {
        return this.getType() == 4;
    }

    public boolean isGroup() {
        return this.getType() == 5;
    }

    public String toString() {
        return this.getAppdefKey();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppdefEntityID)) {
            return false;
        }
        AppdefEntityID o = (AppdefEntityID)other;
        return o._entityID == this._entityID && o._entityType == this._entityType;
    }

    public int hashCode() {
        return this._entityType * 100000 + this._entityID;
    }

    public static AppdefEntityID newPlatformID(Integer id) {
        return new AppdefEntityID(1, id);
    }

    public static AppdefEntityID newServerID(Integer id) {
        return new AppdefEntityID(2, id);
    }

    public static AppdefEntityID newServiceID(Integer id) {
        return new AppdefEntityID(3, id);
    }

    public static AppdefEntityID newAppID(Integer id) {
        return new AppdefEntityID(4, id);
    }

    public static AppdefEntityID newGroupID(Integer id) {
        return new AppdefEntityID(5, id);
    }
}

