/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement;

import java.util.HashMap;
import java.util.Locale;
import org.hyperic.util.units.FormatSpecifics;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.UnitNumber;
import org.hyperic.util.units.UnitsFormat;

public class UnitsConvert {
    private static HashMap unitsToUnit;
    private static HashMap unitsToScale;

    private UnitsConvert() {
    }

    private static void initUnitsToUnit() {
        unitsToUnit = new HashMap();
        unitsToUnit.put("none", new Integer(0));
        unitsToUnit.put("percentage", new Integer(6));
        unitsToUnit.put("percent", new Integer(7));
        unitsToUnit.put("B", new Integer(2));
        unitsToUnit.put("KB", new Integer(2));
        unitsToUnit.put("MB", new Integer(2));
        unitsToUnit.put("GB", new Integer(2));
        unitsToUnit.put("TB", new Integer(2));
        unitsToUnit.put("PB", new Integer(2));
        unitsToUnit.put("b", new Integer(3));
        unitsToUnit.put("bytesToBits", new Integer(9));
        unitsToUnit.put("Kb", new Integer(3));
        unitsToUnit.put("Mb", new Integer(3));
        unitsToUnit.put("Gb", new Integer(3));
        unitsToUnit.put("Tb", new Integer(3));
        unitsToUnit.put("Pb", new Integer(3));
        unitsToUnit.put("epoch-millis", new Integer(5));
        unitsToUnit.put("epoch-seconds", new Integer(5));
        unitsToUnit.put("ns", new Integer(4));
        unitsToUnit.put("mu", new Integer(4));
        unitsToUnit.put("ms", new Integer(4));
        unitsToUnit.put("jiffys", new Integer(4));
        unitsToUnit.put("sec", new Integer(4));
        unitsToUnit.put("cents", new Integer(1));
    }

    private static void initUnitsToScale() {
        unitsToScale = new HashMap();
        unitsToScale.put("none", new Integer(0));
        unitsToScale.put("percentage", new Integer(0));
        unitsToScale.put("percent", new Integer(0));
        unitsToScale.put("B", new Integer(0));
        unitsToScale.put("KB", new Integer(1));
        unitsToScale.put("MB", new Integer(2));
        unitsToScale.put("GB", new Integer(3));
        unitsToScale.put("TB", new Integer(4));
        unitsToScale.put("PB", new Integer(5));
        unitsToScale.put("b", new Integer(0));
        unitsToScale.put("bytesToBits", new Integer(0));
        unitsToScale.put("Kb", new Integer(1));
        unitsToScale.put("Mb", new Integer(2));
        unitsToScale.put("Gb", new Integer(3));
        unitsToScale.put("Tb", new Integer(4));
        unitsToScale.put("Pb", new Integer(5));
        unitsToScale.put("epoch-millis", new Integer(13));
        unitsToScale.put("epoch-seconds", new Integer(11));
        unitsToScale.put("ns", new Integer(15));
        unitsToScale.put("mu", new Integer(14));
        unitsToScale.put("ms", new Integer(13));
        unitsToScale.put("jiffys", new Integer(12));
        unitsToScale.put("sec", new Integer(11));
    }

    public static int getUnitForUnit(String unit) {
        Integer res = (Integer)unitsToUnit.get(unit);
        if (res == null) {
            return 0;
        }
        return res;
    }

    public static int getScaleForUnit(String unit) {
        Integer res = (Integer)unitsToScale.get(unit);
        if (res == null) {
            return 0;
        }
        return res;
    }

    public static FormattedNumber convert(double val, String units) {
        return UnitsConvert.convert(val, units, Locale.getDefault());
    }

    public static FormattedNumber convert(double val, String units, Locale locale) {
        return UnitsConvert.convert(val, units, locale, null);
    }

    public static FormattedNumber convert(double val, String units, FormatSpecifics specifics) {
        return UnitsConvert.convert(val, units, Locale.getDefault(), specifics);
    }

    public static FormattedNumber convert(double val, String units, Locale locale, FormatSpecifics specifics) {
        int unit = UnitsConvert.getUnitForUnit(units);
        int scale = UnitsConvert.getScaleForUnit(units);
        return UnitsFormat.format((UnitNumber)new UnitNumber(val, unit, scale), (Locale)locale, (FormatSpecifics)specifics);
    }

    public static FormattedNumber[] convertSame(double[] vals, String units, Locale locale) {
        int unit = UnitsConvert.getUnitForUnit(units);
        int scale = UnitsConvert.getScaleForUnit(units);
        FormattedNumber[] res = UnitsFormat.formatSame((double[])vals, (int)unit, (int)scale, (Locale)locale);
        return res;
    }

    public static FormattedNumber[] convertSame(double[] vals, String units, Locale locale, FormatSpecifics specifics) {
        int unit = UnitsConvert.getUnitForUnit(units);
        int scale = UnitsConvert.getScaleForUnit(units);
        FormattedNumber[] res = UnitsFormat.formatSame((double[])vals, (int)unit, (int)scale, (Locale)locale, (FormatSpecifics)specifics);
        return res;
    }

    public static void main(String[] args) {
        double val = Double.parseDouble(args[0]);
        String units = args[1];
        FormattedNumber number = UnitsConvert.convert(val, units);
        System.out.println(number.toString());
    }

    static {
        UnitsConvert.initUnitsToUnit();
        UnitsConvert.initUnitsToScale();
    }
}

