/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha.proactive.impl;

import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.cluster.ha.proactive.ProviderModel;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.FilterManager;
import com.vmware.vsphere.client.cluster.ha.proactive.impl.InfraHelper;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderManager {
    private static final Log _logger = LogFactory.getLog(ProviderManager.class);
    private InfraHelper _infraController;
    private FilterManager _filterManager = null;
    private Boolean _isInitialized = false;

    public ProviderManager(InfraHelper controller) {
        this._infraController = controller;
    }

    private Boolean isReady() {
        return this._infraController != null && this._infraController.isReady() && this._isInitialized != false;
    }

    public ProviderManager initialize() {
        this._filterManager = new FilterManager(this._infraController);
        this._isInitialized = true;
        return this;
    }

    private ArrayList<ProviderModel> fetchProviders() {
        String[] providers = this._infraController.getHealthManager().queryProviderList();
        if (providers == null || providers.length == 0) {
            _logger.debug((Object)"could not find any healthUpdateProviders");
            return null;
        }
        ArrayList<ProviderModel> validProviders = new ArrayList<ProviderModel>();
        for (String strId : providers) {
            ManagedObjectReference[] unMonitoredHosts = null;
            try {
                unMonitoredHosts = this._infraController.getHealthManager().queryUnmonitoredHosts(strId, this._infraController.getCluster());
            }
            catch (NotFound e) {
                e.printStackTrace();
            }
            if (unMonitoredHosts != null && unMonitoredHosts.length != 0) continue;
            ProviderModel pInfo = new ProviderModel();
            String strName = "";
            try {
                strName = this._infraController.getHealthManager().queryProviderName(strId);
            }
            catch (NotFound e) {
                e.printStackTrace();
            }
            pInfo.nameProvider = strName;
            pInfo.idProvider = strId;
            validProviders.add(pInfo);
        }
        return validProviders;
    }

    public ProviderModel[] getValidProviders() {
        if (!this.isReady().booleanValue()) {
            return null;
        }
        ArrayList<ProviderModel> providers = this.fetchProviders();
        if (providers == null) {
            return null;
        }
        for (ProviderModel provider : providers) {
            provider.isFiltered = this._filterManager.reset().setProvider(provider.idProvider).checkFilterExists();
        }
        ProviderModel[] result = new ProviderModel[providers.size()];
        return providers.toArray(result);
    }
}

