/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.rp;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.cluster.rp.ClusterDataModel;
import com.vmware.vsphere.client.cluster.rp.MorTree;
import com.vmware.vsphere.client.cluster.rp.RestoreRpTreeValidationResult;
import com.vmware.vsphere.client.cluster.rp.RpDataModel;
import com.vmware.vsphere.client.cluster.rp.RpInfo;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class RestoreRpTreeValidator {
    private static final String[] REQUIRED_VMS_PRIVILEGES = new String[]{"Resource.AssignVMToPool"};
    private final ManagedObjectReference _clusterRef;
    private final MorTree<ManagedObjectReference, RpInfo> _rpTree;
    private final DataFetchCommand _dataFetchCommand;
    private final LegacyAuthorizationService _authorizationService;

    public RestoreRpTreeValidator(ManagedObjectReference clusterRef, MorTree<ManagedObjectReference, RpInfo> rpTree, DataFetchCommand dataFetchCommand, LegacyAuthorizationService authorizationService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef, rpTree, dataFetchCommand, authorizationService});
        this._clusterRef = clusterRef;
        this._rpTree = rpTree;
        this._dataFetchCommand = dataFetchCommand;
        this._authorizationService = authorizationService;
    }

    public RestoreRpTreeValidationResult validate() throws Exception {
        if (!this._clusterRef.equals((Object)this._rpTree.getMetadata())) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.DIFFERENT_CLUSTER_ERROR);
        }
        ClusterDataModel clusterData = Util.getDataModel(ClusterDataModel.class, this._clusterRef, this._dataFetchCommand);
        if (clusterData == null) {
            throw new Exception("Error retrieving data for cluster: " + this._clusterRef);
        }
        if (!clusterData.drsEnabled) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.DRS_DISABLED_ERROR);
        }
        if (clusterData.childRps != null && clusterData.childRps.length > 0) {
            return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.HAS_CHILD_RP_ERROR);
        }
        if (this.haveVmsWithMissingPrivileges()) {
            RestoreRpTreeValidationResult restoreRpTreeValidationResult = new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.VMS_WITH_MISSING_PRIVILEGES_ERROR);
            return restoreRpTreeValidationResult;
        }
        return new RestoreRpTreeValidationResult(RestoreRpTreeValidationResult.ValidationResultType.SUCCESS);
    }

    private boolean haveVmsWithMissingPrivileges() throws Exception {
        RpDataModel rootRpData = Util.getDataModel(RpDataModel.class, this._rpTree.getRootMor(), this._dataFetchCommand);
        if (rootRpData == null) {
            throw new Exception("Error retrieving data for cluster root resource pool: " + this._rpTree.getRootMor());
        }
        boolean privilegesGranted = true;
        if (rootRpData.vms != null && rootRpData.vms.length > 0) {
            final HashSet presentVmsSet = new HashSet();
            Collections.addAll(presentVmsSet, rootRpData.vms);
            final ArrayList vmsToMoveInToRps = new ArrayList();
            this._rpTree.traverse(new MorTree.Visitor<RpInfo>(){

                @Override
                public boolean visit(ManagedObjectReference mor, RpInfo info, List<ManagedObjectReference> children) throws Exception {
                    for (ManagedObjectReference vm : info.getVms()) {
                        if (!presentVmsSet.contains(vm)) continue;
                        vmsToMoveInToRps.add(vm);
                    }
                    return true;
                }
            });
            if (!vmsToMoveInToRps.isEmpty()) {
                privilegesGranted = this._authorizationService.checkPrivileges((ManagedObjectReference[])ArrayUtil.toArray(vmsToMoveInToRps, ManagedObjectReference.class), REQUIRED_VMS_PRIVILEGES);
            }
        }
        return !privilegesGranted;
    }
}

