/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.util;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventUtil {
    private static final Log _logger = LogFactory.getLog(EventUtil.class);

    public static EventDescription.EventDetail getEventDetail(Event event, VcService vcService) {
        if (event == null) {
            _logger.error((Object)"EvenUtil: event is null");
            return null;
        }
        if (vcService == null) {
            _logger.error((Object)"EvenUtil: vcService is null");
            return null;
        }
        String key = null;
        String eventTypeName = event.getClass().getSimpleName();
        key = event instanceof ExtendedEvent ? ((ExtendedEvent)event).eventTypeId : (event instanceof EventEx ? ((EventEx)event).eventTypeId : eventTypeName);
        if (key != null) {
            if (key.startsWith("Vmomi.Event.")) {
                key = key.substring("Vmomi.Event.".length());
            }
            EventDescription.EventDetail eventDetail = new EventDescription.EventDetail();
            eventDetail.setCategory(EventUtil.getLocalizedMessage(String.format("%s.category", key), vcService));
            eventDetail.setDescription(EventUtil.getLocalizedMessage(String.format("%s.description", key), vcService));
            eventDetail.setFormatOnComputeResource(EventUtil.getLocalizedMessage(String.format("%s.formatOnComputeResource", key), vcService));
            eventDetail.setFormatOnDatacenter(EventUtil.getLocalizedMessage(String.format("%s.formatOnDatacenter", key), vcService));
            eventDetail.setFormatOnHost(EventUtil.getLocalizedMessage(String.format("%s.formatOnHost", key), vcService));
            eventDetail.setFormatOnVm(EventUtil.getLocalizedMessage(String.format("%s.formatOnVm", key), vcService));
            eventDetail.setFullFormat(EventUtil.getLocalizedMessage(String.format("%s.fullFormat", key), vcService));
            eventDetail.key = new TypeNameImpl(eventTypeName);
            return eventDetail;
        }
        return null;
    }

    public static EventDescription.EventCategory getEventCategory(Event event, VcService vcService) {
        if (event == null) {
            _logger.error((Object)"EvenUtil: event is null");
            return null;
        }
        if (vcService == null) {
            _logger.error((Object)"EvenUtil: vcService is null");
            return null;
        }
        return EventUtil.getEventCategory(EventUtil.getEventDetail(event, vcService), vcService);
    }

    public static EventDescription.EventCategory getEventCategory(EventDescription.EventDetail eventDetail, VcService vcService) {
        if (eventDetail == null) {
            _logger.error((Object)"EvenUtil: eventDetail is null");
            return null;
        }
        if (vcService == null) {
            _logger.error((Object)"EvenUtil: vcService is null");
            return null;
        }
        for (EventDescription.EventCategory cat : EventDescription.EventCategory.values()) {
            String catLabel = EventUtil.getLocalizedMessage(String.format("event.EventDescription.EventCategory.%s.label", cat.name()), vcService);
            if (!catLabel.equals(eventDetail.getCategory())) continue;
            return cat;
        }
        return null;
    }

    private static String getLocalizedMessage(String catalogKey, VcService vcService) {
        return LocalizationUtil.getLocalizedMessage((String)catalogKey);
    }
}

