/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.cluster.DasAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverLevelAdmissionControlPolicy;
import com.vmware.vim.binding.vim.cluster.FailoverResourcesAdmissionControlPolicy;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;

public class ClusterComputeResourceExtendedDataModel {
    @DerivedProperty(value="ClusterComputeResource/isNetworkUtilizationAvailable")
    public static boolean isNetworkUtilizationAvailable(@SourceProperty(value="ClusterComputeResource/configuration/drsConfig/enabled") boolean isDrsEnabled, @SourceProperty(value="ClusterComputeResource/parent") ManagedObjectReference clusterRefParent) {
        String vcVersion = ClusterComputeResourceExtendedDataModel.getVcVersion(clusterRefParent);
        boolean isVc65OrLater = VcServiceUtil.is65VcOrLaterByVersion((String)vcVersion);
        return isDrsEnabled && isVc65OrLater;
    }

    @DerivedProperty(value="ClusterComputeResource/isHaAdvancedRuntimeInfoPortletAvailable")
    public static boolean isHaAdvancedRuntimeInfoPortletAvailable(@SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy") DasAdmissionControlPolicy policy, @SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled") boolean isAdmissionControlEnabled) {
        boolean isPolicyTypeCorrect = policy instanceof FailoverLevelAdmissionControlPolicy;
        return isPolicyTypeCorrect && isAdmissionControlEnabled;
    }

    @DerivedProperty(value="ClusterComputeResource/isHaAdvancedRuntimeInfoResourcesPortletAvailable")
    public static boolean isHaAdvancedRuntimeInfoResourcesPortletAvailable(@SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlPolicy") DasAdmissionControlPolicy policy, @SourceProperty(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled") boolean isAdmissionControlEnabled) {
        boolean isPolicyTypeCorrect = policy instanceof FailoverResourcesAdmissionControlPolicy;
        return isPolicyTypeCorrect && isAdmissionControlEnabled;
    }

    private static String getVcVersion(ManagedObjectReference clusterRefParent) {
        if (clusterRefParent == null) {
            throw new IllegalArgumentException("Null cluster parent moref encountered.");
        }
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry(null);
        LinkedVcGroup group = registry.getLinkedGroupByServiceUuid(clusterRefParent.getServerGuid());
        VcService vcService = group.getVcService(clusterRefParent.getServerGuid());
        return vcService.getServiceVersion();
    }
}

