/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.configuration;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.util.DrsUtil;

@QueryBinding(value="ClusterComputeResource")
public class ClusterConfigData {
    @Property(value="ClusterComputeResource/name")
    public String clusterName;
    @Property(value="ClusterComputeResource/parent")
    public ManagedObjectReference parent;
    @Property(value="ClusterComputeResource/grandparentDc")
    public transient ManagedObjectReference datacenter;
    @Relationship(value={"ClusterComputeResource/parent"})
    @Property(value="Folder/name")
    public transient String parentFolderName;
    @Relationship(value={"ClusterComputeResource/grandparentDc"})
    @Property(value="Datacenter/name")
    public transient String grandparentDcName;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    public boolean drsEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/enabled")
    public boolean haEnabled;
    @Property(value="ClusterComputeResource/configurationEx/vsanConfigInfo/enabled")
    public boolean vsanEnabled;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/defaultVmBehavior")
    public DrsConfigInfo.DrsBehavior defaultDrsBehavior;
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/vmotionRate")
    public transient int migrationRate;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/admissionControlEnabled")
    public boolean admissionControlEnabled;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/hostMonitoring")
    public String hostMonitoring;
    @Property(value="ClusterComputeResource/configurationEx/dasConfig/vmMonitoring")
    public String vmMonitoring;

    public ManagedObjectReference getLocation() {
        return this.grandparentDcName != null ? this.datacenter : this.parent;
    }

    public String getLocationName() {
        return this.grandparentDcName != null ? this.grandparentDcName : this.parentFolderName;
    }

    public int getMigrationThreshold() {
        return DrsUtil.getDrsVMotionMigrationThreshold(this.migrationRate);
    }
}

