/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolBaseCapacityData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolCpuReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmCpuReservationUsersData;
import com.vmware.vsphere.client.clusterui.util.ResourceReservationUtil;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="AnyResourcePool")
public class ResourcePoolCpuCapacityData
extends ResourcePoolBaseCapacityData {
    @Property(value="AnyResourcePool/config/cpuAllocation/expandableReservation")
    public boolean expandableReservation;
    @Property(value="AnyResourcePool/runtime/cpu/unreservedForVm")
    protected long availableCapacity;
    @Property(value="AnyResourcePool/runtime/cpu/reservationUsed")
    protected long reservedCapacity;
    @NestedQueryBinding
    @Relationship(value={"AnyResourcePool/vm"})
    protected VmCpuReservationUsersData[] vms;
    @NestedQueryBinding
    @Relationship(value={"AnyResourcePool/resourcePool"})
    protected ResourcePoolCpuReservationUsersData[] resourcePools;
    @Property(value="AnyResourcePool/config/cpuAllocation/reservation")
    protected long configuredReservation;

    public String getConfiguredReservationFormatted() {
        return Util.getCpuFormatted(this.configuredReservation);
    }

    @Override
    public String getRpReservationCapacityFormatted() {
        return Util.getCpuFormatted(this.getReservationCapacity());
    }

    @Override
    public String getAvailableCapacityFormatted() {
        return Util.getCpuFormatted(this.availableCapacity);
    }

    @Override
    public String getReservedCapacityFormatted() {
        return Util.getCpuFormatted(this.reservedCapacity);
    }

    @Override
    protected long getAvailableCapacity() {
        return this.availableCapacity;
    }

    @Override
    protected long getReservedCapacity() {
        return this.reservedCapacity;
    }

    @Override
    protected VmBaseReservationUsersData[] getVms() {
        return ResourceReservationUtil.getVmsCpuSharesValuePercentages(this.vms, this.resourcePools);
    }

    @Override
    protected ResourcePoolBaseReservationUsersData[] getResourcePools() {
        return ResourceReservationUtil.getRpsCpuSharesValuePercentages(this.vms, this.resourcePools);
    }
}

