/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.vsphere.client.clusterui.util.Util;

public abstract class GuestUtilizationData {
    protected abstract long guestMemorySizeValue();

    protected abstract long privateMemoryValue();

    protected abstract long sharedMemoryValue();

    protected abstract long swappedMemoryValue();

    protected abstract long balloonedMemoryValue();

    protected abstract long guestMemoryUsageValue();

    protected abstract long compressedMemoryValue();

    public long getUnaccessedMemory() {
        return this.guestMemorySizeValue() - (this.privateMemoryValue() + this.sharedMemoryValue() + this.swappedMemoryValue() + this.getCompressedMemory() + this.balloonedMemoryValue());
    }

    public String getActiveGuestMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.guestMemoryUsageValue());
    }

    public String getPrivateMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.privateMemoryValue());
    }

    public String getSharedMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.sharedMemoryValue());
    }

    public String getCompressedMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.getCompressedMemory());
    }

    public String getSwappedMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.swappedMemoryValue());
    }

    public String getBalloonedMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.balloonedMemoryValue());
    }

    public String getUnaccessedMemoryFormatted() {
        return Util.getMbMemoryFormatted(this.getUnaccessedMemory());
    }

    public String getGuestMemorySizeFormatted() {
        return Util.getMbMemoryFormatted(this.guestMemorySizeValue());
    }

    public double getActiveGuestMemoryPercentage() {
        return Util.getPercentageValue(this.guestMemoryUsageValue(), this.guestMemorySizeValue());
    }

    public double getPrivateMemoryPercentage() {
        return Util.getPercentageValue(this.privateMemoryValue(), this.guestMemorySizeValue());
    }

    public double getSharedMemoryPercentage() {
        return Util.getPercentageValue(this.sharedMemoryValue(), this.guestMemorySizeValue());
    }

    public double getCompressedMemoryPercentage() {
        return Util.getPercentageValue(this.getCompressedMemory(), this.guestMemorySizeValue());
    }

    public double getSwappedMemoryPercentage() {
        return Util.getPercentageValue(this.swappedMemoryValue(), this.guestMemorySizeValue());
    }

    public double getBalloonedMemoryPercentage() {
        return Util.getPercentageValue(this.balloonedMemoryValue(), this.guestMemorySizeValue());
    }

    public double getUnaccessedMemoryPercentage() {
        return Util.getPercentageValue(this.getUnaccessedMemory(), this.guestMemorySizeValue());
    }

    private long getCompressedMemory() {
        long memory = 0L;
        if (this.compressedMemoryValue() > 0L) {
            memory = Math.round(this.compressedMemoryValue() / 1024L);
        }
        return memory;
    }
}

