/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.cluster.InfraUpdateHaConfigInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.cluster.ha.proactive.ProviderModel;
import com.vmware.vsphere.client.clusterui.model.ClusterProviderModel;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@QueryBinding(value="ClusterComputeResource")
public class ClusterProactiveHaConfigData
extends IdentifiableQueryBinding {
    private static final Log _logger = LogFactory.getLog(ClusterProactiveHaConfigData.class);
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig.enabled")
    public boolean infraUpdateHaEnabled;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig/behavior")
    public String behaviorInfraUpdate;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig/moderateRemediation")
    public transient String moderateRemediation;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig/severeRemediation")
    public transient String severeRemediation;
    @Property(value="ClusterComputeResource/healthUpdateProviders")
    public transient ProviderModel[] registeredOnClusterHealthUpdateProviders;
    @Property(value="ClusterComputeResource/configurationEx/infraUpdateHaConfig/providers")
    public transient String[] enabledOnClusterProviders;

    public ClusterProviderModel[] getClusterProviders() {
        if (ArrayUtil.isNullOrEmpty((Object[])this.registeredOnClusterHealthUpdateProviders)) {
            return new ClusterProviderModel[0];
        }
        ClusterProviderModel[] clusterProviderModelResult = new ClusterProviderModel[this.registeredOnClusterHealthUpdateProviders.length];
        for (int i = 0; i < clusterProviderModelResult.length; ++i) {
            ProviderModel tempProviderModel = this.registeredOnClusterHealthUpdateProviders[i];
            ClusterProviderModel clusterProviderModel = new ClusterProviderModel(tempProviderModel);
            clusterProviderModel.isEnabled = !ArrayUtil.isNullOrEmpty((Object[])this.enabledOnClusterProviders) && Arrays.asList(this.enabledOnClusterProviders).contains(tempProviderModel.idProvider);
            clusterProviderModelResult[i] = clusterProviderModel;
        }
        return clusterProviderModelResult;
    }

    public String getProactiveHaRemediationLevel() {
        if (this.moderateRemediation == null) {
            _logger.warn((Object)"moderateRemediation property is not set, remediation level is defaulting to maintenance.");
        }
        if (this.severeRemediation == null) {
            _logger.warn((Object)"moderateRemediation property is not set, remediation level is defaulting to maintenance.");
        }
        String quarantineMode = InfraUpdateHaConfigInfo.RemediationType.QuarantineMode.toString();
        String maintenanceMode = InfraUpdateHaConfigInfo.RemediationType.MaintenanceMode.toString();
        if (quarantineMode.equals(this.moderateRemediation) && quarantineMode.equals(this.severeRemediation)) {
            return "quarantine";
        }
        if (maintenanceMode.equals(this.severeRemediation) && quarantineMode.equals(this.moderateRemediation)) {
            return "balanced";
        }
        return "maintenance";
    }
}

