/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.services;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

@QueryBinding(value="VirtualMachine")
public class VmVmcpSupportData
extends IdentifiableQueryBinding {
    @Property(value="VirtualMachine/ftRole")
    public transient Integer ftRole;
    @Relationship(value={"VirtualMachine/host"})
    @Property(value="HostSystem/capability/ftVmcpSupported")
    public transient Boolean isFtVmcpSupportedOnVmHost;
    @Property(value="VirtualMachine/secondaries")
    public transient ManagedObjectReference[] secondaryVMs;
    @Relationship(value={"VirtualMachine/secondaries", "VirtualMachine/host"})
    @Property(value="HostSystem/capability/ftVmcpSupported")
    public transient Boolean[] ftVmcpSupportedOnSecondaryVmsHosts;

    public boolean isVmcpSupportedForVm() {
        boolean isVmcpSupportedForVm = true;
        if (this.ftRole != null && this.ftRole >= 1) {
            if (this.isFtVmcpSupportedOnVmHost == null || !this.isFtVmcpSupportedOnVmHost.booleanValue()) {
                isVmcpSupportedForVm = false;
            } else if (this.secondaryVMs != null && this.secondaryVMs.length > 0) {
                if (this.secondaryVMs.length > this.ftVmcpSupportedOnSecondaryVmsHosts.length) {
                    isVmcpSupportedForVm = false;
                } else {
                    for (Boolean isFtVmcpSupportedOnHost : this.ftVmcpSupportedOnSecondaryVmsHosts) {
                        isVmcpSupportedForVm = isVmcpSupportedForVm && Boolean.TRUE.equals(isFtVmcpSupportedOnHost);
                    }
                }
            }
        }
        return isVmcpSupportedForVm;
    }
}

