/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.summary;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.clusterui.util.Util;

@QueryBinding(value="ClusterComputeResource")
public class ClusterResourcesData
extends IdentifiableQueryBinding {
    @Property(value="ClusterComputeResource/host/length")
    transient int hostCount;
    @Property(value="ClusterComputeResource/currentEVCModeLabel")
    transient String currentEVCModeLabel;
    @Property(value="ClusterComputeResource/freePMemCapacity")
    transient Long freePmem;
    @Property(value="ClusterComputeResource/totalPMemCapacity")
    transient Long totalPmem;

    public String getEvcStatusText() {
        return StringUtil.isNullOrEmpty((String)this.currentEVCModeLabel) ? Util.getLocalizedString("evc.spoofingdisabled", new String[0]) : this.currentEVCModeLabel;
    }

    public String getNumHostsText() {
        return Util.getLocalizedString("resources.hostUnits", Integer.toString(this.hostCount));
    }

    public boolean getHasPmemStorage() {
        return this.totalPmem != null && this.totalPmem > 0L;
    }

    public String getPmemUsagePercentage() {
        if (this.totalPmem == null || this.freePmem == null || this.totalPmem == 0L) {
            return String.format("%.0f", 0.0);
        }
        return String.format("%.0f", Float.valueOf((float)(this.totalPmem - this.freePmem) * 100.0f / (float)this.totalPmem.longValue()));
    }

    public String getPmemUsageText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return ClusterResourcesData.formatDataSize(0, 0x100000L);
        }
        return ClusterResourcesData.formatDataSize(this.totalPmem - this.freePmem, 0x100000L);
    }

    public String getPmemSizeText() {
        if (this.totalPmem == null || this.freePmem == null) {
            return ClusterResourcesData.formatDataSize(0, 0x100000L);
        }
        return ClusterResourcesData.formatDataSize(this.totalPmem, 0x100000L);
    }

    private static String formatDataSize(Number bytes, long base) {
        return FormatUtil.getDataSizeFormatted((Number)bytes, (int)2, (long)base, (long)-1L, (boolean)true);
    }
}

