/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.util;

import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.ActionHistory;
import com.vmware.vim.binding.vim.cluster.HostPowerAction;
import com.vmware.vim.binding.vim.cluster.InitialPlacementAction;
import com.vmware.vim.binding.vim.cluster.MigrationAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.clusterui.model.monitor.history.DrsActionHistoryListItem;
import com.vmware.vsphere.client.clusterui.util.Util;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DrsActionHistoryUtil {
    public static List<ManagedObjectReference> collectTargetsFromActionHistory(ActionHistory actionHistory) {
        ArrayList<ManagedObjectReference> objectsForAction = new ArrayList<ManagedObjectReference>();
        if (actionHistory.getAction() instanceof HostPowerAction) {
            if (actionHistory.getAction().getTarget() != null) {
                objectsForAction.add(actionHistory.getAction().getTarget());
            }
        } else if (actionHistory.getAction() instanceof MigrationAction) {
            MigrationAction action = (MigrationAction)actionHistory.getAction();
            if (action.getDrsMigration() != null) {
                objectsForAction.add(action.getDrsMigration().getVm());
                objectsForAction.add(action.getDrsMigration().getSource());
                objectsForAction.add(action.getDrsMigration().getDestination());
            }
        } else if (actionHistory.getAction() instanceof InitialPlacementAction) {
            if (actionHistory.getAction().getTarget() != null) {
                objectsForAction.add(actionHistory.getAction().getTarget());
            }
            InitialPlacementAction action = (InitialPlacementAction)actionHistory.getAction();
            objectsForAction.add(action.getTargetHost());
        }
        return objectsForAction;
    }

    public static List<DrsActionHistoryListItem> makeGridData(ActionHistory[] actionHistory, Map<ActionHistory, List<ManagedObjectReference>> objectsPerHistoryItem, Map<Object, MonitorTargetData> objectDataByRef) {
        ArrayList<DrsActionHistoryListItem> listItems = new ArrayList<DrsActionHistoryListItem>();
        for (ActionHistory actionHistoryItem : actionHistory) {
            MonitorTargetData targetData;
            Action action = actionHistoryItem.getAction();
            List<ManagedObjectReference> historyItemObjects = objectsPerHistoryItem.get(actionHistoryItem);
            ArrayList<MonitorTargetData> targetObjects = new ArrayList<MonitorTargetData>();
            boolean skipItem = false;
            if (historyItemObjects != null) {
                for (ManagedObjectReference actionObject : historyItemObjects) {
                    targetData = objectDataByRef.get(actionObject);
                    if (targetData != null) {
                        targetObjects.add(objectDataByRef.get(actionObject));
                        continue;
                    }
                    skipItem = true;
                }
            }
            if (skipItem) continue;
            DrsActionHistoryListItem listItem = new DrsActionHistoryListItem();
            listItem.setTargetObjects(targetObjects.toArray(new MonitorTargetData[0]));
            listItem.setText(DrsActionHistoryUtil.getActionHistoryText(action));
            listItem.setTime(actionHistoryItem.getTime().getTimeInMillis());
            ManagedObjectReference actionTarget = DrsActionHistoryUtil.getActionHistoryTarget(action);
            if (actionTarget != null && (targetData = objectDataByRef.get(actionTarget)) != null) {
                listItem.setImage(targetData.getPrimaryIconId());
            }
            listItems.add(listItem);
        }
        return listItems;
    }

    private static String getActionHistoryText(Action action) {
        if (action instanceof HostPowerAction) {
            HostPowerAction hostPowerAction = (HostPowerAction)action;
            if (hostPowerAction.operationType.equals((Object)HostPowerAction.OperationType.powerOff)) {
                return Util.getLocalizedString("drs.action.powerOffHost", new String[0]);
            }
            return Util.getLocalizedString("drs.action.powerOnHost", new String[0]);
        }
        if (action instanceof MigrationAction) {
            return Util.getLocalizedString("drs.action.migrateVm", new String[0]);
        }
        if (action instanceof InitialPlacementAction) {
            return Util.getLocalizedString("drs.action.placeVm", new String[0]);
        }
        return "";
    }

    private static ManagedObjectReference getActionHistoryTarget(Action action) {
        MigrationAction migrationAction;
        ManagedObjectReference target = null;
        if (action instanceof HostPowerAction || action instanceof InitialPlacementAction) {
            target = action.getTarget();
        } else if (action instanceof MigrationAction && (migrationAction = (MigrationAction)action).getDrsMigration() != null) {
            target = migrationAction.getDrsMigration().getVm();
        }
        return target;
    }
}

