/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import com.vmware.automatic.plugin.registration.services.PrintHelper;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class PluginCmd {
    final ConnectionService connectionService;
    final PluginExtensionRegistryService registryService;
    final CommandLineParser parser;
    CommandLine _commandLine;

    public PluginCmd(ConnectionService connectionService, PluginExtensionRegistryService registryService, CommandLineParser parser) {
        this.registryService = registryService;
        this.connectionService = connectionService;
        this.parser = parser;
    }

    public Options getPluginOpts() {
        Options options = new Options();
        options.addOption(Option.builder("action").hasArg().argName("action").desc("registerPlugin, unregisterPlugin, updatePlugin, isPluginRegistered").required().build());
        options.addOption(Option.builder("url").hasArg().argName("vc url").desc("vCenter server URL").required().build());
        options.addOption(Option.builder("u").longOpt("username").hasArg().argName("vc user").desc("vCenter server username").required().build());
        options.addOption(Option.builder("p").longOpt("password").hasArg().argName("vc pass").desc("vCenter server password").required().build());
        options.addOption(Option.builder("k").longOpt("key").hasArg().argName("key").desc("Plugin key").required().build());
        return options;
    }

    public void execute(String[] args) throws Exception {
        try {
            this.parseCommandLineArguments(args);
            this.connect();
            this.doExecute();
        }
        catch (ParseException e) {
            PrintHelper.printHelp(this.getPluginOpts(), e.getMessage());
            throw new ParseException(e.getMessage());
        }
        catch (Exception e) {
            String msg = String.format("[ERROR] An error occurred while executing the following action: '%s'", this._commandLine.getOptionValue("action"));
            if (e.getMessage() != null) {
                msg = msg + System.lineSeparator() + e.getMessage();
            }
            throw new RuntimeException(msg, e);
        }
        finally {
            try {
                this.disconnect();
            }
            catch (SOAPFaultException e) {
                PrintHelper.printSoapFaultException(e);
                throw e;
            }
            catch (Exception e) {
                System.out.println("Failed to disconnect - " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private void parseCommandLineArguments(String[] commandLineArgs) throws ParseException {
        Options options = this.getPluginOpts();
        this._commandLine = this.parser.parse(options, commandLineArgs);
    }

    private void connect() {
        this.connectionService.connect(this._commandLine);
    }

    private void disconnect() {
        this.connectionService.disconnect(this._commandLine);
    }

    protected abstract void doExecute() throws Exception;
}

