/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import com.vmware.automatic.plugin.registration.services.TrustAllTrustManager;
import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.commons.cli.CommandLine;

public class ConnectionService {
    private static final ManagedObjectReference SVC_INST_REF = new ManagedObjectReference();
    private static final String SVC_INST_NAME = "ServiceInstance";
    private final VimService vimService;
    private final TrustAllTrustManager trustManager;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private ManagedObjectReference extensionManager;
    private boolean isConnected;

    public ConnectionService(VimService vimService, TrustAllTrustManager trustManager) {
        this.vimService = vimService;
        this.trustManager = trustManager;
    }

    public void connect(CommandLine commandLine) {
        if (this.isConnected) {
            return;
        }
        String _username = commandLine.getOptionValue("u");
        String _password = commandLine.getOptionValue("p");
        String url = commandLine.getOptionValue("url");
        try {
            this.trustManager.trustAll();
            SVC_INST_REF.setType(SVC_INST_NAME);
            SVC_INST_REF.setValue(SVC_INST_NAME);
            this.vimPort = this.vimService.getVimPort();
            Map ctxt = ((BindingProvider)this.vimPort).getRequestContext();
            ctxt.put("javax.xml.ws.service.endpoint.address", url);
            ctxt.put("javax.xml.ws.session.maintain", true);
            this.serviceContent = this.vimPort.retrieveServiceContent(SVC_INST_REF);
            this.vimPort.login(this.serviceContent.getSessionManager(), _username, _password, null);
            this.extensionManager = this.serviceContent.getExtensionManager();
            this.isConnected = true;
        }
        catch (InvalidLocaleFaultMsg | InvalidLoginFaultMsg | RuntimeFaultFaultMsg e) {
            String msg = String.format("Error while connecting to vCenter Server SDK <%s>. Please verify the provided arguments are correct: -url: %s, -username: %s, -password: %s", url, url, _username, _password);
            throw new RuntimeException(msg, e);
        }
    }

    public void disconnect(CommandLine commandLine) {
        if (!this.isConnected) {
            return;
        }
        String url = commandLine.getOptionValue("url");
        try {
            this.getVimPort().logout(this.serviceContent.getSessionManager());
        }
        catch (RuntimeFaultFaultMsg e) {
            String msg = String.format("Error while disconnecting from vCenter Server SDK <%s>.", url);
            throw new RuntimeException(msg, e);
        }
        finally {
            this.isConnected = false;
        }
    }

    public VimPortType getVimPort() {
        if (this.vimPort == null) {
            throw new RuntimeException("No Connection to vCenter Server established");
        }
        return this.vimPort;
    }

    public ManagedObjectReference getExtensionManager() {
        if (this.extensionManager == null) {
            throw new RuntimeException("No connection to vCenter Server established.");
        }
        return this.extensionManager;
    }
}

