/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.automatic.plugin.registration.services;

import com.vmware.vim25.Description;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionClientInfo;
import com.vmware.vim25.ExtensionResourceInfo;
import com.vmware.vim25.ExtensionServerInfo;
import com.vmware.vim25.KeyValue;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;

public class PluginExtensionRegistryService {
    private static final String LOCAL_PLUGIN_TYPE = "vsphere-client-serenity";
    private static final String REMOTE_PLUGIN_TYPE = "vsphere-client-remote";
    private static final String HTTPS_PROTOCOL = "HTTPS";
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final String ADMIN_EMAIL = "noreply@vmware.com";

    public void updateTopLevelProperties(Extension extension, CommandLine commandLine) {
        String version = commandLine.getOptionValue("v");
        String company = commandLine.getOptionValue("c");
        boolean showInSolutionManager = commandLine.hasOption("show");
        if (extension.getKey() == null) {
            extension.setKey(commandLine.getOptionValue("k"));
        }
        extension.setVersion(version != null ? version : extension.getVersion());
        extension.setCompany(company != null ? company : extension.getCompany());
        extension.setShownInSolutionManager(showInSolutionManager);
    }

    public void updateDescription(Extension extension, CommandLine commandLine) {
        Description description;
        String name = commandLine.getOptionValue("n");
        String summary = commandLine.getOptionValue("s");
        if (extension.getDescription() != null) {
            description = extension.getDescription();
        } else {
            description = new Description();
            description.setLabel("");
            description.setSummary("");
        }
        description.setLabel(name != null ? name : description.getLabel());
        description.setSummary(summary != null ? summary : description.getSummary());
        extension.setDescription(description);
    }

    public void updateClientInfo(Extension extension, CommandLine commandLine) {
        ExtensionClientInfo extClientInfo;
        String version = commandLine.getOptionValue("v");
        String company = commandLine.getOptionValue("c");
        String pluginUrl = commandLine.getOptionValue("pu");
        boolean isRemotePlugin = commandLine.hasOption("remote");
        if (extension.getClient().size() > 0) {
            extClientInfo = extension.getClient().get(0);
        } else {
            extClientInfo = new ExtensionClientInfo();
            extClientInfo.setType(isRemotePlugin ? REMOTE_PLUGIN_TYPE : LOCAL_PLUGIN_TYPE);
            extClientInfo.setCompany("");
        }
        extClientInfo.setVersion(version != null ? version : extClientInfo.getVersion());
        extClientInfo.setCompany(company != null ? company : extClientInfo.getCompany());
        extClientInfo.setDescription(extension.getDescription());
        extClientInfo.setUrl(pluginUrl != null ? pluginUrl : extClientInfo.getUrl());
        if (extension.getClient().size() == 0) {
            extension.getClient().add(extClientInfo);
        } else {
            extension.getClient().set(0, extClientInfo);
        }
    }

    public void updateResourceInfo(Extension extension, CommandLine commandLine) {
        ExtensionResourceInfo extResourceInfo;
        String name = commandLine.getOptionValue("n");
        if (extension.getResourceList().size() > 0) {
            extResourceInfo = extension.getResourceList().get(0);
        } else {
            extResourceInfo = new ExtensionResourceInfo();
            extResourceInfo.setLocale("en_US");
            extResourceInfo.setModule("name");
            KeyValue kvPair = new KeyValue();
            kvPair.setKey("name");
            kvPair.setValue("");
            extResourceInfo.getData().add(kvPair);
        }
        extResourceInfo.getData().get(0).setValue(name != null ? name : extResourceInfo.getData().get(0).getValue());
        if (extension.getResourceList().size() > 0) {
            extension.getResourceList().set(0, extResourceInfo);
        } else {
            extension.getResourceList().add(extResourceInfo);
        }
    }

    public void updateServerInfo(Extension extension, CommandLine commandLine) throws MissingArgumentException {
        String pluginUrl = commandLine.getOptionValue("pu");
        String serverThumbprint = commandLine.getOptionValue("st");
        String company = commandLine.getOptionValue("c");
        if (!this.isNewPluginUrlHttp(pluginUrl) && this.isCurrentExtensionHttps(extension) && this.anyServerInfoMemberToUpdate(commandLine) || this.isNewPluginUrlHttps(pluginUrl)) {
            ExtensionServerInfo extServerInfo;
            if (extension.getServer().size() > 0) {
                extServerInfo = extension.getServer().get(0);
            } else {
                if (serverThumbprint == null) {
                    throw new MissingArgumentException(Option.builder("st").build());
                }
                extServerInfo = new ExtensionServerInfo();
                extServerInfo.setType(HTTPS_PROTOCOL);
                extServerInfo.getAdminEmail().add(ADMIN_EMAIL);
                extServerInfo.setCompany("");
            }
            extServerInfo.setDescription(extension.getDescription());
            extServerInfo.setServerThumbprint(serverThumbprint != null ? serverThumbprint : extServerInfo.getServerThumbprint());
            extServerInfo.setUrl(pluginUrl != null ? pluginUrl : extServerInfo.getUrl());
            extServerInfo.setCompany(company != null ? company : extServerInfo.getCompany());
            if (extension.getServer().size() == 0) {
                extension.getServer().add(extServerInfo);
            } else if (this.isNewPluginUrlHttp(pluginUrl)) {
                extension.getServer().set(0, extServerInfo);
            }
        } else if (this.isNewPluginUrlHttp(pluginUrl)) {
            System.out.println("INFO: Not using https for your plugin URL is OK for testing but not recommended for production.\nUsers will have to include the flag allowHttp=true in their vSphere Client webclient.properties otherwise the http URL will be ignored");
            extension.getServer().clear();
        }
    }

    public void updatelastHeartbeatTime(Extension extension) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = dtFactory.newXMLGregorianCalendar(cal);
        extension.setLastHeartbeatTime(xmlCalendar);
    }

    private boolean isCurrentExtensionHttps(Extension extension) {
        return extension.getServer().size() > 0 && HTTPS_PROTOCOL.equalsIgnoreCase(extension.getServer().get(0).getType());
    }

    private boolean isNewPluginUrlHttps(String pluginUrl) {
        return pluginUrl != null && pluginUrl.toLowerCase().startsWith(HTTPS_PROTOCOL.toLowerCase());
    }

    private boolean isNewPluginUrlHttp(String pluginUrl) {
        return pluginUrl != null && pluginUrl.toLowerCase().startsWith(HTTP_PROTOCOL.toLowerCase().concat("://"));
    }

    private boolean anyServerInfoMemberToUpdate(CommandLine commandLine) {
        return commandLine.getOptionValue("c") != null || commandLine.getOptionValue("st") != null || commandLine.getOptionValue("n") != null || commandLine.getOptionValue("s") != null;
    }
}

