/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.CustomizationSpecInfo;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.fault.MissingLinuxCustResources;
import com.vmware.vim.binding.vim.fault.MissingWindowsCustResources;
import com.vmware.vim.binding.vim.fault.UncustomizableGuest;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.data.CustomizeGosSpecData;
import com.vmware.vsphere.client.h5.vm.impl.CustomizationSpecsHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmCustomizationSpecsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmCustomizationSpecsPropertyProviderAdapter.class);
    private static final String CUSTOMIZE_GOS_SPEC_DATA = "customizeGosSpecData";
    private static final String PROP_GUEST_ID = "VirtualMachine/config/guestId";
    private static final String PROP_GUEST_FULL_NAME = "VirtualMachine/config/guestFullName";
    private static final String PROP_PENDING_CUSOMITZATION = "VirtualMachine/config/tools/pendingCustomization";
    private static final String WIN_OS_PREFIX = "win";
    private static final String GOS_TYPE_WINDOWS = "Windows";
    private static final String GOS_TYPE_LINUX = "Linux";
    private final ObjectReferenceService _objReferenceService;
    private CustomizationSpecsHelper _customizationSpecsHelper;

    public VmCustomizationSpecsPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory, ObjectReferenceService objReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{registry});
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._objReferenceService = objReferenceService;
        this._customizationSpecsHelper = new CustomizationSpecsHelper(queryServiceFactory);
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = "*";
        ti.properties = new String[]{CUSTOMIZE_GOS_SPEC_DATA};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propRequestSpec});
        Object[] objects = propRequestSpec.objects;
        PropertySpec[] properties = propRequestSpec.properties;
        if (objects == null || objects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        for (Object obj : objects) {
            try {
                PropertySpec propSpec = this.getPropertyRequested(CUSTOMIZE_GOS_SPEC_DATA, properties);
                if (propSpec == null) continue;
                ManagedObjectReference vmRef = (ManagedObjectReference)obj;
                String vCenterId = (String)propSpec.parameters[0].parameter;
                CustomizeGosSpecData customizationSpecData = this.getCustomizeGosSpecData(vmRef, vCenterId);
                ResultItem ri = this.createResultItem(obj, customizationSpecData, CUSTOMIZE_GOS_SPEC_DATA);
                resultItems.add(ri);
            }
            catch (Exception e) {
                faults.add(MixedUtil.getMethodFault((Throwable)e));
            }
        }
        if (!faults.isEmpty()) {
            result.error = new CompositeException(faults);
        }
        result.items = resultItems.toArray(new ResultItem[0]);
        return result;
    }

    private PropertySpec getPropertyRequested(String property, PropertySpec[] properties) {
        for (PropertySpec pSpec : properties) {
            for (String p : pSpec.propertyNames) {
                if (!property.equals(p)) continue;
                return pSpec;
            }
        }
        return null;
    }

    private CustomizeGosSpecData getCustomizeGosSpecData(ManagedObjectReference vmRef, String vCenterId) throws Exception {
        CustomizeGosSpecData data2 = new CustomizeGosSpecData();
        ManagedObjectReference vcRef = (ManagedObjectReference)this._objReferenceService.getReference(vCenterId, true);
        data2.vmCustomizePrivGranted = this._customizationSpecsHelper.isCustomizeSpecPrivilegeGrantedOnVm(vmRef);
        if (!data2.vmCustomizePrivGranted) {
            _logger.info((Object)("Customize spec privileges are not granted on VM: " + vmRef));
            return data2;
        }
        data2.vcReadSpecPrivGranted = this._customizationSpecsHelper.isReadSpecsPrivilegeGrantedOnVcenter(vcRef);
        if (!data2.vcReadSpecPrivGranted) {
            return data2;
        }
        List<Object> vmProperties = this._customizationSpecsHelper.fetchVmProperties(vmRef, PROP_GUEST_ID, PROP_GUEST_FULL_NAME, PROP_PENDING_CUSOMITZATION);
        String guestId = (String)vmProperties.get(0);
        String guestFullName = (String)vmProperties.get(1);
        boolean pendingCustomization = !StringUtil.isNullOrEmpty((String)((String)vmProperties.get(2)));
        data2.guestId = guestId;
        data2.guestFullName = guestFullName;
        data2.pendingCustomization = pendingCustomization;
        if (pendingCustomization) {
            return data2;
        }
        CustomizationSpecInfo[] filteredSpecs = null;
        VcService service = VimSessionUtil.getService((String)vcRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        try {
            manager.checkResources(guestId);
            CustomizationSpecInfo[] specs = manager.getInfo();
            if (specs != null) {
                String sourceVmGuestOsType;
                data2.guestType = sourceVmGuestOsType = guestId.startsWith(WIN_OS_PREFIX) ? GOS_TYPE_WINDOWS : GOS_TYPE_LINUX;
                filteredSpecs = this.filterSpecs(specs, sourceVmGuestOsType);
            }
            data2.compatibility = CustomizeGosSpecData.Compatibility.CUSTOMIZATION_RESOURCES_VALID;
        }
        catch (MissingWindowsCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data2.compatibility = CustomizeGosSpecData.Compatibility.MISSING_WINDOWS_CUSTOMIZATION;
        }
        catch (MissingLinuxCustResources e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data2.compatibility = CustomizeGosSpecData.Compatibility.MISSING_LINUX_CUSTOMIZATION;
        }
        catch (UncustomizableGuest e) {
            _logger.debug((Object)e.getMessage(), (Throwable)e);
            data2.compatibility = CustomizeGosSpecData.Compatibility.UNCUSTOMIZABLE_GUEST;
        }
        data2.relevantSpecs = filteredSpecs;
        return data2;
    }

    private CustomizationSpecInfo[] filterSpecs(CustomizationSpecInfo[] specs, String typeToFilterBy) {
        ArrayList<CustomizationSpecInfo> list = new ArrayList<CustomizationSpecInfo>();
        for (CustomizationSpecInfo spec : specs) {
            if (!typeToFilterBy.equals(spec.type)) continue;
            list.add(spec);
        }
        return list.toArray(new CustomizationSpecInfo[0]);
    }

    private ResultItem createResultItem(Object obj, Object objValue, String propertyName) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = obj;
        pv.propertyName = propertyName;
        pv.value = objValue;
        ResultItem ri = new ResultItem();
        ri.resourceObject = obj;
        ri.properties = new PropertyValue[]{pv};
        return ri;
    }
}

