/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.security.AuthorizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VmPropertyProvider {
    private static final String CONNECTION_STATE_PROP = "runtime/connectionState";
    private static final String TEMPLATE_PROP = "config/template";
    private static final String DISABLED_METHODS_PROP = "disabledMethod";
    private static final String RELOCATE_TASK = "RelocateVM_Task";
    private static final String VM_PATH_NAME_PROP = "vmPathName";
    private static final String VM_DATASTORE_PROP = "datastore";
    private static final String NAME_PROP = "name";
    private static Pattern DATASTORE_NAME_PATTERN = Pattern.compile("^\\[(.*)\\]");
    private QueryService _queryService;

    public VmPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="VirtualMachine/isMoveFromDragAndDropAvailable")
    public Collection<Boolean> getIsMoveFromDragAndDropAvailable(Collection<ManagedObjectReference> vmRefs) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(vmRefs.size());
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", CONNECTION_STATE_PROP, TEMPLATE_PROP, DISABLED_METHODS_PROP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        HashMap<ManagedObjectReference, Boolean> propValueMap = new HashMap<ManagedObjectReference, Boolean>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Boolean isTemplate;
            VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)resourceItem.get(CONNECTION_STATE_PROP);
            boolean isConnected = VirtualMachine.ConnectionState.connected.equals((Object)connectionState);
            boolean isOperationAllowed = true;
            if (isConnected && Boolean.FALSE.equals(isTemplate = (Boolean)resourceItem.get(TEMPLATE_PROP))) {
                String[] disabledMethods = (String[])resourceItem.get(DISABLED_METHODS_PROP);
                isOperationAllowed = AuthorizationUtil.isOperationAllowed((String[])new String[]{RELOCATE_TASK}, (String[])disabledMethods);
            }
            propValueMap.put((ManagedObjectReference)resourceItem.getKey(), isConnected && isOperationAllowed);
        }
        for (ManagedObjectReference vmRef : vmRefs) {
            result.add((Boolean)propValueMap.get(vmRef));
        }
        return result;
    }

    @PropertyProvider(value="VirtualMachine/vmHomeDatastore")
    public Collection<ManagedObjectReference> getVmHomeDatastore(Collection<ManagedObjectReference> vmRefs) {
        ResultSet vmPropsResultSet = this._queryService.select(new String[]{VM_PATH_NAME_PROP, VM_DATASTORE_PROP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        HashSet<ManagedObjectReference> allDatastores = new HashSet<ManagedObjectReference>();
        for (ResourceItem resourceItem : vmPropsResultSet.getItems()) {
            ManagedObjectReference[] dsRefs = (ManagedObjectReference[])resourceItem.get(VM_DATASTORE_PROP);
            if (dsRefs == null) continue;
            allDatastores.addAll(Arrays.asList(dsRefs));
        }
        HashMap<ManagedObjectReference, String> dsNames = new HashMap<ManagedObjectReference, String>();
        if (!allDatastores.isEmpty()) {
            ResultSet dsPropsResultSet = this._queryService.select(new String[]{NAME_PROP}).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, allDatastores).fetch();
            for (ResourceItem resourceItem : dsPropsResultSet.getItems()) {
                dsNames.put((ManagedObjectReference)resourceItem.getKey(), (String)resourceItem.get(NAME_PROP));
            }
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (ResourceItem resourceItem : vmPropsResultSet.getItems()) {
            Matcher matcher;
            ManagedObjectReference vmHomeDsRef = null;
            String vmPathName = (String)resourceItem.get(VM_PATH_NAME_PROP);
            if (vmPathName != null && (matcher = DATASTORE_NAME_PATTERN.matcher(vmPathName)).find()) {
                String vmHomeDsName = matcher.group(1);
                ManagedObjectReference[] vmDsRefs = (ManagedObjectReference[])resourceItem.get(VM_DATASTORE_PROP);
                if (vmDsRefs != null && vmHomeDsName != null) {
                    for (ManagedObjectReference dsRef : vmDsRefs) {
                        if (!vmHomeDsName.equals(dsNames.get(dsRef))) continue;
                        vmHomeDsRef = dsRef;
                        break;
                    }
                }
            }
            result.add(vmHomeDsRef);
        }
        return result;
    }
}

