/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.Util;
import com.vmware.vsphere.client.contentLibrary.ContentLibraryUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateVmPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(CreateVmPropertyProviderAdapter.class);
    private static final String OVF_CAPABILITY_SESSION_KEY_PREFIX = "ovfCapabilityCache";
    private static final int DEPLOY_OVF_CACHE_DURATION = 900000;
    private static final String DEPLOY_OVF_ALLOWED_PROP = "isDeployOvfAvailable";
    private static final String CREATE_VM_ALLOWED_PROP = "isCreateVmAllowed";
    private static final String HOST_CONNECTION_STATE_PROP = "runtime.connectionState";
    private static final String HOST_IN_MM_PROP = "runtime.inMaintenanceMode";
    private static final String HOST_PARENT_PROP = "parent";
    private static final String DRS_ENABLED_PROP = "drsEnabled";
    private static final String ENVIRONMENT_BROWSER_PROP = "environmentBrowser";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String PRIVILEGE_ASSIGN_VM_TO_POOL = "Resource.AssignVMToPool";
    private static final String VAPP_IMPORT_PRIVILEGE_NAME = "VApp.Import";
    private final QueryExecutor _queryExecutor;
    private final DataServiceExtensionRegistry _dsExtensionRegistry;
    private final ContentLibraryUtil _contentLibraryUtil;

    public CreateVmPropertyProviderAdapter(QueryExecutor queryExecutor, DataServiceExtensionRegistry registry, ContentLibraryUtil contentLibraryUtil) {
        this._queryExecutor = queryExecutor;
        this._dsExtensionRegistry = registry;
        this._contentLibraryUtil = contentLibraryUtil;
    }

    public void initialize() {
        TypeInfo ti = new TypeInfo();
        ti.type = HostSystem.class.getSimpleName();
        ti.properties = new String[]{DEPLOY_OVF_ALLOWED_PROP, CREATE_VM_ALLOWED_PROP};
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, new TypeInfo[]{ti});
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ResultSet result = new ResultSet();
        Object[] objects = propertyRequest.objects;
        PropertySpec[] propertySpecs = propertyRequest.properties;
        HashSet<String> requestedPropertyNames = new HashSet<String>();
        for (PropertySpec ps : propertySpecs) {
            requestedPropertyNames.addAll(Arrays.asList(ps.propertyNames));
        }
        ResultItem[] resultItems = new ResultItem[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object currentObject = objects[i];
            if (!(currentObject instanceof ManagedObjectReference)) {
                _logger.warn((Object)("Non-managed object passed." + currentObject));
                continue;
            }
            ManagedObjectReference mor = (ManagedObjectReference)currentObject;
            if (!HostSystem.class.getSimpleName().equals(mor.getType())) {
                _logger.warn((Object)("Expected a host, received " + mor));
                continue;
            }
            resultItems[i] = this.getResultItem(mor, requestedPropertyNames);
        }
        result.totalMatchedObjectCount = objects.length;
        result.items = resultItems;
        return result;
    }

    private ResultItem getResultItem(ManagedObjectReference sourceObject, Set<String> requestedPropertyNames) {
        assert (requestedPropertyNames != null);
        ResultItem result = new ResultItem();
        result.resourceObject = sourceObject;
        if (!requestedPropertyNames.contains(DEPLOY_OVF_ALLOWED_PROP) && !requestedPropertyNames.contains(CREATE_VM_ALLOWED_PROP)) {
            _logger.warn((Object)("Neither property provided by provider has been requested.Requested properties are: " + requestedPropertyNames.toString()));
            return result;
        }
        PropertyValue[] propVals = new PropertyValue[requestedPropertyNames.size()];
        VmDeployAvailabilityResult availabilityResult = this.retrieveData(sourceObject);
        int i = 0;
        for (String propertyName : requestedPropertyNames) {
            if (DEPLOY_OVF_ALLOWED_PROP.equals(propertyName)) {
                propVals[i++] = CreateVmPropertyProviderAdapter.propertyValue(sourceObject, propertyName, availabilityResult.deployOvfAllowed);
                continue;
            }
            if (CREATE_VM_ALLOWED_PROP.equals(propertyName)) {
                propVals[i++] = CreateVmPropertyProviderAdapter.propertyValue(sourceObject, propertyName, availabilityResult.createVmAllowed);
                continue;
            }
            _logger.debug((Object)("Non-provided property requested: " + propertyName));
        }
        result.properties = propVals;
        return result;
    }

    private VmDeployAvailabilityResult retrieveData(ManagedObjectReference host) {
        VmDeployAvailabilityResult result = new VmDeployAvailabilityResult();
        try {
            boolean hostInNonDeployableState;
            PropertyValue[] values = this._queryExecutor.getProperties((Object)host, new String[]{HOST_CONNECTION_STATE_PROP, HOST_IN_MM_PROP, HOST_PARENT_PROP});
            Boolean hostInMaintenanceMode = (Boolean)Util.getProperty((PropertyValue[])values, (String)HOST_IN_MM_PROP);
            HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)Util.getProperty((PropertyValue[])values, (String)HOST_CONNECTION_STATE_PROP);
            ManagedObjectReference parent = (ManagedObjectReference)Util.getProperty((PropertyValue[])values, (String)HOST_PARENT_PROP);
            boolean bl = hostInNonDeployableState = hostInMaintenanceMode != null && hostInMaintenanceMode != false || connectionState != HostSystem.ConnectionState.connected;
            if (parent == null) {
                return CreateVmPropertyProviderAdapter.negativeResult();
            }
            boolean isHostClustered = ClusterComputeResource.class.getSimpleName().equals(parent.getType());
            if (!isHostClustered && hostInNonDeployableState) {
                return CreateVmPropertyProviderAdapter.negativeResult();
            }
            PropertyValue[] crValues = this._queryExecutor.getProperties((Object)parent, new String[]{DRS_ENABLED_PROP, ENVIRONMENT_BROWSER_PROP, GRANTED_PRIVILEGES_PROP});
            ManagedObjectReference envBrowser = (ManagedObjectReference)Util.getProperty((PropertyValue[])crValues, (String)ENVIRONMENT_BROWSER_PROP);
            if (envBrowser == null) {
                return CreateVmPropertyProviderAdapter.negativeResult();
            }
            Boolean clusterDrsEnabled = (Boolean)Util.getProperty((PropertyValue[])crValues, (String)DRS_ENABLED_PROP);
            if (isHostClustered && clusterDrsEnabled != null && !clusterDrsEnabled.booleanValue() && hostInNonDeployableState) {
                return CreateVmPropertyProviderAdapter.negativeResult();
            }
            String[] grantedPrivileges = (String[])Util.getProperty((PropertyValue[])crValues, (String)GRANTED_PRIVILEGES_PROP);
            boolean isCreateVmPrivilegeGranted = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{PRIVILEGE_ASSIGN_VM_TO_POOL}, (String[])grantedPrivileges);
            boolean isDeployOvfPrivilegeGranted = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VAPP_IMPORT_PRIVILEGE_NAME}, (String[])grantedPrivileges);
            result.createVmAllowed = isCreateVmPrivilegeGranted;
            result.deployOvfAllowed = isDeployOvfPrivilegeGranted && this._contentLibraryUtil.getIsDeployOvfSupported(parent);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieving properties for availability check.", (Throwable)e);
            result.createVmAllowed = true;
            result.deployOvfAllowed = true;
            return result;
        }
    }

    private static PropertyValue propertyValue(Object resourceObject, String propertyName, Object val) {
        PropertyValue result = new PropertyValue();
        result.propertyName = propertyName;
        result.resourceObject = resourceObject;
        result.value = val;
        return result;
    }

    private static VmDeployAvailabilityResult negativeResult() {
        VmDeployAvailabilityResult result = new VmDeployAvailabilityResult();
        result.createVmAllowed = false;
        result.deployOvfAllowed = false;
        return result;
    }

    private static class VmDeployAvailabilityResult {
        boolean createVmAllowed;
        boolean deployOvfAllowed;

        private VmDeployAvailabilityResult() {
        }
    }
}

