/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.core.model.EntitySpecPair;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.commonservice.util.NameValidationUtil;
import com.vmware.vsphere.client.h5.vm.MoveEntityInfo;
import com.vmware.vsphere.client.h5.vm.MultipleVmQuestionAnswerSpec;
import com.vmware.vsphere.client.h5.vm.NameValidationResult;
import com.vmware.vsphere.client.h5.vm.ValidateNameSpec;
import com.vmware.vsphere.client.h5.vm.data.CompatibilityCheckResult;
import com.vmware.vsphere.client.h5.vm.data.RegisterVmCompatibilityCheckSpec;
import com.vmware.vsphere.client.h5.vm.data.RegisterVmSpec;
import com.vmware.vsphere.client.h5.vm.data.ValidateMoveVmSpec;
import com.vmware.vsphere.client.h5.vm.data.VmCryptoUnlockSpec;
import com.vmware.vsphere.client.h5.vm.data.VmEvcSpec;
import com.vmware.vsphere.client.h5.vm.model.VmMoveEntityData;
import com.vmware.vsphere.client.h5.vm.model.migration.VmMigrationCancelRecommendationsSpec;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import com.vmware.vsphere.client.vm.api.VmQuestionAnswerSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VmMutationProvider.class);
    private static final String VM_QUESTION_ID_PROP_NAME = "runtime/question/id";
    private static final String VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME = "vmQuestionId";
    private static final String NAME_PROPERTY = "name";
    private static final String PARENT_PROPERTY = "parent";
    private static final String PARENT_FOLDER_PROPERTY = "parentFolder";
    private static final String PRIVILEGE_ASSIGN_VM_TO_POOL = "Resource.AssignVMToPool";
    private static final String PRIVILEGE_ASSIGN_VM_TO_VAPP = "VApp.AssignVM";
    private static final String PRIVILEGE_ASSIGN_VM_INVENTORY_MOVE = "VirtualMachine.Inventory.Move";
    private static final String PRIVILEGE_SYSTEM_READ = "System.Read";
    private static final String CLUSTER_DRS_ENABLED_PROP_NAME = "configurationEx/drsConfig/enabled";
    private static final String RP_PROP_NAME = "resourcePool";
    private static final String GRANTED_PRIVS_PROP_NAME = "grantedPrivileges";
    private static final String RP_ALL_HOSTS_PROP_NAME = "allHosts";
    private static final String RP_IS_ROOT_RP_PROP_NAME = "isRootRP";
    private static final String HOST_COUNT_PROP_NAME = "host/length";
    private static final String HOST_PROP_NAME = "host";
    private static final String CLUSTER_PROP_NAME = "cluster";
    private static final String HOST_CONNECTION_STATE_PROP_NAME = "runtime/connectionState";
    private static final String HOST_MAINTENANCE_MODE_PROP_NAME = "runtime/inMaintenanceMode";
    private static final String HOST_DISABLED_METHOD_PROP_NAME = "disabledMethod";
    private static final String DATASTORE_PROP_NAME = "datastore";
    private static final String IS_RP_IN_VAPP_PROP_NAME = "isInVApp";
    private static final String VM_FOLDER_PROP_NAME = "vmFolder";
    private static final String SELECT_RES_POOL_NO_PERMISSION_LOCALIZATION_KEY = "SelectResourcePoolProvisioningPage.NoPermission";
    private static final String ENTER_MAINTENANCE_MODE_TASK = "EnterMaintenanceMode_Task";
    private static final String EXIT_MAINTENANCE_MODE_TASK = "ExitMaintenanceMode_Task";
    private static final String PRIVILEGE = "Privilege.";
    public final MutationService _mutationService;
    public final QueryServiceFactory _queryServiceFactory;
    private final LegacyAuthorizationService _authorizationService;
    public final QueryBindingServiceFactory _queryBindingServiceFactory;
    private final ThreadPoolExecutor _threadPoolExecutor;
    private final QueryService _queryService;

    public VmMutationProvider(MutationService mutationService, QueryServiceFactory queryServiceFactory, LegacyAuthorizationService authorizationService, QueryBindingServiceFactory queryBindingServiceFactory, ThreadPoolExecutor threadPoolExecutor) {
        this._mutationService = mutationService;
        this._queryServiceFactory = queryServiceFactory;
        this._authorizationService = authorizationService;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
        this._threadPoolExecutor = threadPoolExecutor;
        this._queryService = this._queryServiceFactory.getQueryService();
    }

    public OperationResult apply(ManagedObjectReference vmRef, MultipleVmQuestionAnswerSpec multipleVmsAnswerSpec) {
        EntitySpecPair[] specPairs;
        String logMessagePrefix = "apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): ";
        VmQuestionAnswerSpec sourceVmAnswerSpec = new VmQuestionAnswerSpec();
        sourceVmAnswerSpec.questionId = multipleVmsAnswerSpec.questionId;
        sourceVmAnswerSpec.answerChoice = multipleVmsAnswerSpec.answerChoice;
        ArrayList<ManagedObjectReference> vmsToAnswer = new ArrayList<ManagedObjectReference>();
        vmsToAnswer.add(vmRef);
        _logger.info((Object)("apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): Source VM MoRef=" + vmRef));
        if (ArrayUtil.isNullOrEmpty((Object[])multipleVmsAnswerSpec.otherVmRefs)) {
            _logger.info((Object)"apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): There are no other VMs");
            EntitySpecPair specPair = this.getSpecPair(vmRef, sourceVmAnswerSpec);
            specPairs = new EntitySpecPair[]{specPair};
        } else {
            _logger.info((Object)("apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): Other VM MoRefs are: " + Arrays.toString(multipleVmsAnswerSpec.otherVmRefs)));
            ResultSet vmQuestionIds = this._queryService.select(new String[]{"@modelKey", VM_QUESTION_ID_PROP_NAME}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(multipleVmsAnswerSpec.otherVmRefs)), new PropertyPredicate(VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)multipleVmsAnswerSpec.firstMessageId)}).fetch();
            Integer otherVmsCount = vmQuestionIds.getItems().size();
            _logger.info((Object)String.format("apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): otherVmsCount=%d", otherVmsCount));
            specPairs = new EntitySpecPair[otherVmsCount + 1];
            specPairs[0] = this.getSpecPair(vmRef, sourceVmAnswerSpec);
            Integer index = 1;
            for (ResourceItem vmQuestionIdItem : vmQuestionIds.getItems()) {
                ManagedObjectReference otherVmRef = (ManagedObjectReference)vmQuestionIdItem.getKey();
                vmsToAnswer.add(otherVmRef);
                String otherVmQuestionId = vmQuestionIdItem.getPropertyValues().get(1).toString();
                VmQuestionAnswerSpec otherVmAnswerSpec = new VmQuestionAnswerSpec();
                otherVmAnswerSpec.questionId = otherVmQuestionId;
                otherVmAnswerSpec.answerChoice = sourceVmAnswerSpec.answerChoice;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                specPairs[n.intValue()] = this.getSpecPair(otherVmRef, otherVmAnswerSpec);
            }
        }
        this._mutationService.applyMulti(specPairs);
        _logger.info((Object)String.format("apply(ManagedObjectReference, MultipleVmQuestionAnswerSpec): Mutation operation applied to %d specPairs", specPairs.length));
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        result.effect = new OperationEffect();
        result.effect.affectedEntites = vmsToAnswer.toArray(new ManagedObjectReference[0]);
        return result;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmCryptoUnlockSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            result.task = vm.cryptoUnlock();
        }
        catch (Exception e) {
            _logger.error((Object)("Could not unlock encrypted VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)vmRef)), (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootFolder, VmMigrationCancelRecommendationsSpec spec) throws Exception {
        Validate.notEmpty((Object[])spec.keys, (String)"recommendations keys cannot be empty");
        VcService vcService = VimSessionUtil.getService((String)rootFolder.getServerGuid());
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        StorageResourceManager storageManager = (StorageResourceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.storageResourceManager);
        try {
            storageManager.cancelRecommendation(spec.keys);
        }
        catch (InvalidArgument e) {
            _logger.debug((Object)("Failed to cancel recommendations. The specified keys refers to a non-existent or an already executed recommendation. Fault:  " + e.getMessage()));
        }
        OperationResult result = new OperationResult();
        result.entity = rootFolder;
        return result;
    }

    public ValidationResult validate(final ValidateNameSpec nameSpec) {
        ValidationResult result = new ValidationResult();
        final NameValidationResult validationResult = new NameValidationResult();
        result.result = validationResult;
        if (!NameValidationUtil.validate((String)nameSpec.name)) {
            validationResult.error = VmStringUtil.getString("NameValidator.nameTooLongSpecialChars");
            return result;
        }
        ManagedObjectReference vmFolderRef = nameSpec.folderRef;
        if (nameSpec.datacenterRef != null && nameSpec.folderRef == null) {
            ResultSet vmFolderQuery = this._queryService.select(new String[]{"@modelKey", VM_FOLDER_PROP_NAME}).from(new String[]{Datacenter.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)nameSpec.datacenterRef)}).fetch();
            vmFolderRef = (ManagedObjectReference)((ResourceItem)vmFolderQuery.getItems().get(0)).get(VM_FOLDER_PROP_NAME);
        }
        validationResult.vmFolderRef = vmFolderRef;
        int matchingNamesCount = 0;
        try {
            ArrayList<Callable<Integer>> dsRequests = new ArrayList<Callable<Integer>>();
            final HttpServletRequest httpRequest = SessionUtil.getHttpRequest();
            dsRequests.add(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)httpRequest);
                    ResultSet vmsInFolder = VmMutationProvider.this._queryService.select(new String[]{"@modelKey"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(VmMutationProvider.PARENT_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)validationResult.vmFolderRef), new PropertyPredicate(VmMutationProvider.NAME_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)nameSpec.name)}).fetch();
                    return vmsInFolder.getItems().size();
                }
            });
            dsRequests.add(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)httpRequest);
                    ResultSet vAppsInFolder = VmMutationProvider.this._queryService.select(new String[]{"@modelKey"}).from(new String[]{VirtualApp.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(VmMutationProvider.PARENT_FOLDER_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)validationResult.vmFolderRef), new PropertyPredicate(VmMutationProvider.NAME_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)nameSpec.name)}).fetch();
                    return vAppsInFolder.getItems().size();
                }
            });
            List responses = this._threadPoolExecutor.invokeAll(dsRequests);
            for (Future response : responses) {
                matchingNamesCount += ((Integer)response.get()).intValue();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            _logger.debug((Object)String.format("Failed to check if a VM or vApp with the same name already exists in the selected folder. Fault: %s ", ex.getMessage(), ex));
        }
        if (matchingNamesCount > 0) {
            validationResult.error = VmStringUtil.getString("SelectNameFolderProvisioningPage.DuplicateName");
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference moRef, ValidateMoveVmSpec moveSpec) throws Exception {
        List<MoveEntityInfo> moveEntities;
        QueryBindingService queryBindingService = this._queryBindingServiceFactory.getQueryBindingService();
        ValidationResult result = new ValidationResult();
        boolean isTargetValid = true;
        String targetErrorMessage = VmStringUtil.getString("MoveValidation.targetPrivilegeError");
        PropertyValue[] targetPrivileges = this._authorizationService.getPrivileges(new ManagedObjectReference[]{moRef});
        if (targetPrivileges != null && targetPrivileges.length > 0 && targetPrivileges[0] != null) {
            String[] privileges = (String[])targetPrivileges[0].value;
            String reqPrivilege = PRIVILEGE_ASSIGN_VM_INVENTORY_MOVE;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ResourcePool.class)) {
                reqPrivilege = PRIVILEGE_ASSIGN_VM_TO_POOL;
                targetErrorMessage = VmStringUtil.getString("MoveValidation.targetResourcePoolPrivilegeError");
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VirtualApp.class)) {
                reqPrivilege = PRIVILEGE_ASSIGN_VM_TO_VAPP;
                targetErrorMessage = VmStringUtil.getString("MoveValidation.targetVAppPrivilegeError");
            }
            isTargetValid = AuthorizationUtil.isPrivilegeGranted((String[])new String[]{reqPrivilege}, (String[])privileges);
        }
        if (!isTargetValid) {
            result.result = targetErrorMessage;
            return result;
        }
        ArrayList<ManagedObjectReference> list = new ArrayList<ManagedObjectReference>(Arrays.asList(moveSpec.entities));
        Collection moveEntitiesData = queryBindingService.prepare(VmMoveEntityData.class).fetch(list);
        if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)moRef)) {
            int parentVAppCount = 0;
            for (VmMoveEntityData entity : moveEntitiesData) {
                if (entity.parentVApp == null) continue;
                ++parentVAppCount;
            }
            if (parentVAppCount == moveEntitiesData.size()) {
                result.result = VmStringUtil.getString("MoveValidation.allVmsAreInVappAndTargetIsFolderError");
                return result;
            }
            if (parentVAppCount > 0) {
                result.result = VmStringUtil.getString("MoveValidation.someVmsAreInVappAndTargetIsFolderError");
                return result;
            }
        }
        if ((moveEntities = MoveEntityInfo.buildMoveEntityInfo(moveEntitiesData, moRef)).isEmpty()) {
            result.result = VmStringUtil.getString("MoveValidation.targetValidationError");
            return result;
        }
        if (moveEntities.size() != moveSpec.entities.length) {
            result.result = VmStringUtil.getString("MoveValidation.targetValidationErrorSome");
            return result;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference targetRef, RegisterVmCompatibilityCheckSpec spec) {
        ValidationUtil.notNull((Object)spec.targetRef);
        ValidationUtil.notNull((Object)spec.datastoreRef);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ClusterComputeResource.class)) {
            return this.runRegisterVmOnClusterPreCheck(targetRef, spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, HostSystem.class)) {
            return this.runRegisterVmOnHostPreCheck(targetRef, spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, ResourcePool.class)) {
            return this.runRegisterVmOnRpOrVappPreCheck(true, targetRef, spec);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)targetRef, VirtualApp.class)) {
            return this.runRegisterVmOnRpOrVappPreCheck(false, targetRef, spec);
        }
        ValidationResult valRes = new ValidationResult();
        CompatibilityCheckResult checkRes = new CompatibilityCheckResult();
        checkRes.localizationKey = "SelectResourcePoolProvisioningPage.SelectRPOnly";
        valRes.result = checkRes;
        return valRes;
    }

    public OperationResult add(RegisterVmSpec spec) {
        OperationResult opResult = new OperationResult();
        try {
            boolean isVappRelated = false;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.targetRef, VirtualApp.class)) {
                isVappRelated = true;
            } else if (!spec.isVmTemplate && ManagedObjectUtil.isOfType((ManagedObjectReference)spec.targetRef, ResourcePool.class)) {
                ResultSet result = this._queryService.select(new String[]{IS_RP_IN_VAPP_PROP_NAME}).from(new String[]{ResourcePool.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.targetRef)}).fetch();
                isVappRelated = (Boolean)((ResourceItem)result.getItems().get(0)).get(IS_RP_IN_VAPP_PROP_NAME);
            }
            String vmName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.vmName);
            if (isVappRelated) {
                ResourcePool pool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.targetRef);
                opResult.task = pool.registerVm(spec.vmPath, vmName, null);
                return opResult;
            }
            Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.folderRef);
            ManagedObjectReference poolRef = null;
            ManagedObjectReference hostRef = null;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.targetRef, ResourcePool.class)) {
                poolRef = spec.targetRef;
                opResult.task = folder.registerVm(spec.vmPath, vmName, spec.isVmTemplate, poolRef, hostRef);
                return opResult;
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.targetRef, HostSystem.class)) {
                hostRef = spec.targetRef;
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)spec.targetRef, ClusterComputeResource.class) || !spec.isVmTemplate) {
                ResultSet result = this._queryService.select(new String[]{RP_PROP_NAME}).from(new String[]{spec.targetRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.targetRef)}).fetch();
                poolRef = (ManagedObjectReference)((ResourceItem)result.getItems().get(0)).get(RP_PROP_NAME);
            }
            opResult.task = folder.registerVm(spec.vmPath, vmName, spec.isVmTemplate, poolRef, hostRef);
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference vmRef, VmEvcSpec spec) throws Exception {
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        try {
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            result.task = vm.applyEvcMode(spec.featureMasks, Boolean.valueOf(true));
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private EntitySpecPair getSpecPair(ManagedObjectReference ref, VmQuestionAnswerSpec spec) {
        EntitySpecPair pairSpec = new EntitySpecPair();
        pairSpec.entity = ref;
        pairSpec.spec = spec;
        return pairSpec;
    }

    private ValidationResult runRegisterVmOnClusterPreCheck(ManagedObjectReference clusterRef, RegisterVmCompatibilityCheckSpec spec) {
        ValidationResult valRes = new ValidationResult();
        CompatibilityCheckResult checkResult = new CompatibilityCheckResult();
        valRes.result = checkResult;
        if (spec.isTemplate && !VcServiceUtil.is66VcOrLaterByServerGuid((String)spec.targetRef.getServerGuid())) {
            checkResult.localizationKey = "regVmHostCluster.selectSpecificHost";
            return valRes;
        }
        ResultSet clusterPropsResult = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME, HOST_PROP_NAME, HOST_COUNT_PROP_NAME, CLUSTER_DRS_ENABLED_PROP_NAME, RP_PROP_NAME}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef)}).fetch();
        ResourceItem clusterPropsItem = (ResourceItem)clusterPropsResult.getItems().get(0);
        String[] grantedPrivs = (String[])clusterPropsItem.get(GRANTED_PRIVS_PROP_NAME);
        CompatibilityCheckResult systemReadCheckResult = this.buildSystemReadCheckResult(grantedPrivs, clusterRef);
        if (systemReadCheckResult.localizationKey != null) {
            valRes.result = systemReadCheckResult;
            return valRes;
        }
        Integer clusterHostCont = (Integer)clusterPropsItem.get(HOST_COUNT_PROP_NAME);
        if (clusterHostCont == 0) {
            checkResult.localizationKey = "regVmHostCluster.emptyClusterError";
            return valRes;
        }
        ManagedObjectReference[] clusterHosts = (ManagedObjectReference[])clusterPropsItem.get(HOST_PROP_NAME);
        boolean hasClusterConnectedHosts = this.isAtLeastOneHostConnected(clusterHosts);
        if (!hasClusterConnectedHosts) {
            checkResult.localizationKey = "regVmHostCluster.NoConnectedHostsFound";
            return valRes;
        }
        boolean isClusterReachableByDs = this.isObjectReachableByDs(clusterRef, spec.datastoreRef);
        if (!isClusterReachableByDs) {
            checkResult.localizationKey = "regVm.ClusterNotReachable";
            return valRes;
        }
        boolean clusterDrsEnabled = (Boolean)clusterPropsItem.get(CLUSTER_DRS_ENABLED_PROP_NAME);
        if (!clusterDrsEnabled) {
            checkResult.localizationKey = "regVmHostCluster.noSpecificHostSelected";
            return valRes;
        }
        ManagedObjectReference clusterRootRpRef = (ManagedObjectReference)clusterPropsItem.get(RP_PROP_NAME);
        boolean isPrivToClusterRpGranted = this.isPrivilegeGranted(clusterRootRpRef, PRIVILEGE_ASSIGN_VM_TO_POOL);
        if (!isPrivToClusterRpGranted) {
            String privText = VmStringUtil.getString("Privilege.Resource.AssignVMToPool");
            checkResult.localizationKey = SELECT_RES_POOL_NO_PERMISSION_LOCALIZATION_KEY;
            checkResult.localizationArgs = new String[]{privText, this.getComputeResourceTypeText(clusterRef)};
        }
        return valRes;
    }

    private ValidationResult runRegisterVmOnHostPreCheck(ManagedObjectReference hostRef, RegisterVmCompatibilityCheckSpec spec) {
        ValidationResult valRes = new ValidationResult();
        CompatibilityCheckResult checkResult = new CompatibilityCheckResult();
        valRes.result = checkResult;
        ResultSet result = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME, HOST_CONNECTION_STATE_PROP_NAME, HOST_MAINTENANCE_MODE_PROP_NAME, HOST_DISABLED_METHOD_PROP_NAME}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
        List items = result.getItems();
        String[] grantedPrivs = (String[])((ResourceItem)items.get(0)).get(GRANTED_PRIVS_PROP_NAME);
        CompatibilityCheckResult systemReadCheckResult = this.buildSystemReadCheckResult(grantedPrivs, hostRef);
        if (systemReadCheckResult.localizationKey != null) {
            valRes.result = systemReadCheckResult;
            return valRes;
        }
        boolean isHostConnected = this.isAtLeastOneHostConnected(items);
        if (!isHostConnected) {
            checkResult.localizationKey = "regVmHostCluster.hostNotConnected";
            return valRes;
        }
        boolean hostIsMountedToDs = this.isObjectReachableByDs(hostRef, spec.datastoreRef);
        if (!hostIsMountedToDs) {
            checkResult.localizationKey = "regVm.HostNotReachable";
            return valRes;
        }
        result = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME}).from(new String[]{ResourcePool.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(RP_ALL_HOSTS_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef), new PropertyPredicate(RP_IS_ROOT_RP_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)true)}).fetch();
        ResourceItem rpGrantedPrivsItem = (ResourceItem)result.getItems().get(0);
        grantedPrivs = (String[])rpGrantedPrivsItem.get(GRANTED_PRIVS_PROP_NAME);
        boolean isPrivToHostRpGranted = this.isPrivilegeGranted(PRIVILEGE_ASSIGN_VM_TO_POOL, grantedPrivs);
        if (!isPrivToHostRpGranted) {
            String privText = VmStringUtil.getString("Privilege.Resource.AssignVMToPool");
            checkResult.localizationKey = SELECT_RES_POOL_NO_PERMISSION_LOCALIZATION_KEY;
            checkResult.localizationArgs = new String[]{privText, this.getComputeResourceTypeText(hostRef)};
        }
        return valRes;
    }

    private ValidationResult runRegisterVmOnRpOrVappPreCheck(boolean isRp, ManagedObjectReference vAppOrRpRef, RegisterVmCompatibilityCheckSpec spec) {
        ValidationResult valRes = new ValidationResult();
        CompatibilityCheckResult checkResult = new CompatibilityCheckResult();
        valRes.result = checkResult;
        String[] properties = new String[]{CLUSTER_PROP_NAME, RP_ALL_HOSTS_PROP_NAME};
        ResultSet clusterPropsResult = this._queryService.select(properties).from(new String[]{vAppOrRpRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)vAppOrRpRef)}).fetch();
        ResourceItem rpProperties = (ResourceItem)clusterPropsResult.getItems().get(0);
        Object[] hosts = (ManagedObjectReference[])rpProperties.get(RP_ALL_HOSTS_PROP_NAME);
        ManagedObjectReference cluster = (ManagedObjectReference)rpProperties.get(CLUSTER_PROP_NAME);
        boolean hasValidHosts = true;
        if (!ArrayUtil.isNullOrEmpty((Object[])hosts)) {
            ResultSet result = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME, HOST_CONNECTION_STATE_PROP_NAME, HOST_MAINTENANCE_MODE_PROP_NAME, HOST_DISABLED_METHOD_PROP_NAME}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(hosts))}).fetch();
            List items = result.getItems();
            ArrayList<ResourceItem> filteredItems = new ArrayList<ResourceItem>();
            for (ResourceItem item : items) {
                String[] privileges = (String[])item.get(GRANTED_PRIVS_PROP_NAME);
                if (!this.isPrivilegeGranted(PRIVILEGE_SYSTEM_READ, privileges)) continue;
                filteredItems.add(item);
            }
            if (!filteredItems.isEmpty()) {
                hasValidHosts = this.isAtLeastOneHostConnected(filteredItems);
            }
        }
        if (!hasValidHosts) {
            checkResult.localizationKey = String.format("regVmHostCluster.%s.%s", isRp ? "ResourcePool" : "VApp", cluster != null ? "ParentClusterNoConnectedHostsFound" : "ParentHostNotConnected");
            return valRes;
        }
        boolean isVappOrRpReachableByDs = this.isObjectReachableByDs(vAppOrRpRef, spec.datastoreRef, "computeResourceDatastore");
        if (!isVappOrRpReachableByDs) {
            checkResult.localizationKey = isRp ? "regVmHostCluster.rpNotReachable" : "regVmHostCluster.vAppNotReachable";
            return valRes;
        }
        String privToCheck = isRp ? PRIVILEGE_ASSIGN_VM_TO_POOL : PRIVILEGE_ASSIGN_VM_TO_VAPP;
        boolean isPrivToRpOrVappGranted = this.isPrivilegeGranted(vAppOrRpRef, privToCheck);
        if (!isPrivToRpOrVappGranted) {
            String privText = VmStringUtil.getString(PRIVILEGE + privToCheck);
            checkResult.localizationKey = SELECT_RES_POOL_NO_PERMISSION_LOCALIZATION_KEY;
            checkResult.localizationArgs = new String[]{privText, this.getComputeResourceTypeText(vAppOrRpRef)};
        }
        return valRes;
    }

    private boolean isObjectReachableByDs(ManagedObjectReference objRef, ManagedObjectReference dsRef, String storagePropName) {
        ResultSet result = this._queryService.select(new String[0]).from(new String[]{objRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef), new PropertyPredicate(storagePropName, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef)}).fetch();
        boolean isReachable = !result.getItems().isEmpty();
        return isReachable;
    }

    private boolean isObjectReachableByDs(ManagedObjectReference objRef, ManagedObjectReference dsRef) {
        return this.isObjectReachableByDs(objRef, dsRef, DATASTORE_PROP_NAME);
    }

    private boolean isAtLeastOneHostConnected(ManagedObjectReference[] hostRefs) {
        ResultSet result = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME, HOST_CONNECTION_STATE_PROP_NAME, HOST_MAINTENANCE_MODE_PROP_NAME, HOST_DISABLED_METHOD_PROP_NAME}).from(new String[]{HostSystem.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(hostRefs))}).fetch();
        List items = result.getItems();
        return this.isAtLeastOneHostConnected(items);
    }

    private boolean isAtLeastOneHostConnected(List<ResourceItem> items) {
        for (ResourceItem item : items) {
            boolean isHostInTransition;
            boolean isHostConnected = item.get(HOST_CONNECTION_STATE_PROP_NAME) == HostSystem.ConnectionState.connected;
            boolean isHostInMaintenanceMode = (Boolean)item.get(HOST_MAINTENANCE_MODE_PROP_NAME);
            String[] disabledMethods = (String[])item.get(HOST_DISABLED_METHOD_PROP_NAME);
            List<String> arrayList = Arrays.asList(disabledMethods);
            boolean bl = isHostInTransition = arrayList.contains(ENTER_MAINTENANCE_MODE_TASK) && arrayList.contains(EXIT_MAINTENANCE_MODE_TASK);
            if (!isHostConnected || isHostInMaintenanceMode || isHostInTransition) continue;
            return true;
        }
        return false;
    }

    private boolean isPrivilegeGranted(ManagedObjectReference objRef, String privilegeToCheck) {
        String[] grantedPrivs = this.getPrivileges(objRef);
        return this.isPrivilegeGranted(privilegeToCheck, grantedPrivs);
    }

    private String[] getPrivileges(ManagedObjectReference objRef) {
        ResultSet result = this._queryService.select(new String[]{GRANTED_PRIVS_PROP_NAME}).from(new String[]{objRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        ResourceItem item = (ResourceItem)result.getItems().get(0);
        String[] grantedPrivs = (String[])item.get(GRANTED_PRIVS_PROP_NAME);
        return grantedPrivs;
    }

    private boolean isPrivilegeGranted(String privilegeToCheck, String[] grantedPrivs) {
        for (String privilege : grantedPrivs) {
            if (!privilege.equals(privilegeToCheck)) continue;
            return true;
        }
        return false;
    }

    private String getComputeResourceTypeText(ManagedObjectReference computeResource) {
        return VmStringUtil.getString("compatibilityError." + computeResource.getType());
    }

    private CompatibilityCheckResult buildSystemReadCheckResult(String[] grantedPrivs, ManagedObjectReference targetRef) {
        CompatibilityCheckResult checkResult = new CompatibilityCheckResult();
        boolean hasSystemRead = this.isPrivilegeGranted(PRIVILEGE_SYSTEM_READ, grantedPrivs);
        if (!hasSystemRead) {
            String privText = VmStringUtil.getString("Privilege.Resource.AssignVMToPool");
            checkResult.localizationKey = SELECT_RES_POOL_NO_PERMISSION_LOCALIZATION_KEY;
            checkResult.localizationArgs = new String[]{privText, this.getComputeResourceTypeText(targetRef)};
        }
        return checkResult;
    }
}

