/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmNetworkSelectorMatcherService {
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final String NETWORK_NAME_PROPERTY = "name";
    private static final String NETWORK_TYPE_PROPERTY = "networkType";
    private static final int NETWORK_TYPE_STANDARD = 1;
    private static final int NETWORK_TYPE_PORTGROUP = 2;
    private static final int NETWORK_TYPE_OPAQUE = 4;
    private static final String DVS_DV_PORT_GROUP_COUNT_PROPERTY = "portgroup._length";
    private static final String ALL_NETWORKS_COUNT_PROPERTY = "allNetwork._length";
    private static final int NETWORK_COUNT_LIMIT = 50;
    private static final Log _logger = LogFactory.getLog(VmNetworkSelectorMatcherService.class);
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _queryBuilder;

    public VmNetworkSelectorMatcherService(QueryExecutor queryExecutor, QuerySpecBuilder queryBuilder) {
        this._queryExecutor = queryExecutor;
        this._queryBuilder = queryBuilder;
    }

    public ManagedObjectReference[] getMatchingNetworks(ManagedObjectReference networkProvider, List<String> sourceNetworkNames) {
        if (networkProvider == null || sourceNetworkNames == null || sourceNetworkNames.isEmpty()) {
            return new ManagedObjectReference[0];
        }
        List<ManagedObjectReference> matchingNetworks = this.fetchMatchingNetworks(networkProvider, sourceNetworkNames);
        if (matchingNetworks.isEmpty()) {
            ManagedObjectReference[] managedObjectReferenceArray;
            ManagedObjectReference singleNetwork = this.fetchIfOnlyOneNetwork(networkProvider);
            if (singleNetwork != null) {
                ManagedObjectReference[] managedObjectReferenceArray2 = new ManagedObjectReference[1];
                managedObjectReferenceArray = managedObjectReferenceArray2;
                managedObjectReferenceArray2[0] = singleNetwork;
            } else {
                managedObjectReferenceArray = new ManagedObjectReference[]{};
            }
            return managedObjectReferenceArray;
        }
        return matchingNetworks.toArray(new ManagedObjectReference[matchingNetworks.size()]);
    }

    private List<ManagedObjectReference> fetchMatchingNetworks(ManagedObjectReference networkProvider, List<String> sourceNeworkNames) {
        Constraint namesConstraint = this.buildMatchingNetworkNamesConstraint(sourceNeworkNames);
        Constraint typesConstraint = this.buildMatchingNetworkTypesConstraint();
        Constraint allNetworks = this.buildAllNetworksConstraint(networkProvider);
        QuerySpec matchingQuery = this._queryBuilder.buildQuerySpec((Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{namesConstraint, typesConstraint, allNetworks}, (Conjoiner)Conjoiner.AND), new String[0]);
        ResultSet matchingNetworkSet = null;
        try {
            matchingNetworkSet = this._queryExecutor.getData(matchingQuery);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve matching networks", (Throwable)e);
        }
        ArrayList<ManagedObjectReference> networks = new ArrayList<ManagedObjectReference>();
        if (matchingNetworkSet != null && matchingNetworkSet.items != null) {
            int length = matchingNetworkSet.items.length;
            for (int index = 0; index < length; ++index) {
                networks.add((ManagedObjectReference)matchingNetworkSet.items[index].resourceObject);
            }
        }
        return networks;
    }

    private ManagedObjectReference fetchIfOnlyOneNetwork(ManagedObjectReference networkProvider) {
        String networkCountProperty = ALL_NETWORKS_COUNT_PROPERTY;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkProvider, DistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)networkProvider, VmwareDistributedVirtualSwitch.class)) {
            networkCountProperty = DVS_DV_PORT_GROUP_COUNT_PROPERTY;
        }
        ManagedObjectReference network = null;
        try {
            int networkCount = (Integer)this._queryExecutor.getProperty((Object)networkProvider, networkCountProperty);
            if (networkCount > 0 && networkCount <= 50) {
                Constraint allNetworks = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{this.buildAllNetworksConstraint(networkProvider), this.buildMatchingNetworkTypesConstraint()}, (Conjoiner)Conjoiner.AND);
                QuerySpec query = this._queryBuilder.buildQuerySpec(allNetworks, new String[0]);
                query.resultSpec = new ResultSpec();
                query.resultSpec.maxResultCount = 2;
                ResultSet rs = this._queryExecutor.getData(query);
                network = rs.items.length == 1 ? (ManagedObjectReference)rs.items[0].resourceObject : null;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve networks information", (Throwable)e);
        }
        return network;
    }

    private Constraint buildMatchingNetworkNamesConstraint(List<String> sourceNetworkNames) {
        Constraint[] nameConstraints = new Constraint[sourceNetworkNames.size()];
        int index = 0;
        for (String networkName : sourceNetworkNames) {
            nameConstraints[index++] = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)NETWORK_NAME_PROPERTY, (Comparator)Comparator.EQUALS, (Object)networkName);
        }
        CompositeConstraint networkNamesConstraint = QueryUtil.createCompositeConstraint((Constraint[])nameConstraints, (Conjoiner)Conjoiner.OR);
        return networkNamesConstraint;
    }

    private Constraint buildMatchingNetworkTypesConstraint() {
        PropertyConstraint pc1 = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)NETWORK_TYPE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)1);
        PropertyConstraint pc2 = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)NETWORK_TYPE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)2);
        PropertyConstraint pc3 = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)NETWORK_TYPE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)4);
        CompositeConstraint networkTypesConstraint = QueryUtil.createCompositeConstraint((Constraint[])new PropertyConstraint[]{pc1, pc2, pc3}, (Conjoiner)Conjoiner.OR);
        return networkTypesConstraint;
    }

    private Constraint buildAllNetworksConstraint(ManagedObjectReference networkProvider) {
        Constraint result = QueryUtil.createConstraintForRelationship((Object)networkProvider, (String)"allNetwork", (String)ANY_NETWORK_TYPE);
        return result;
    }
}

