/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.service.provisioning;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorDatastoreRawData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsData;
import com.vmware.vsphere.client.h5.vm.model.storagelocator.StorageLocatorItemsFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VmProvisioningStorageLocatorService {
    private static final String PROPERTY_DATASTORE = "datastore";
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private final StorageLocatorItemsFactory _storageItemsFactory;

    public VmProvisioningStorageLocatorService(QueryServiceFactory queryServiceFactory, QueryBindingServiceFactory queryBindingServiceFactory, StorageLocatorItemsFactory storageItemsFactory) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._storageItemsFactory = storageItemsFactory;
    }

    public StorageLocatorItemsData getStorageLocatorData(ManagedObjectReference resource, Object[] prefetchedDatastores) {
        Collection<StorageLocatorDatastoreRawData> rawData = this.getAvailableDatastores(resource, prefetchedDatastores);
        StorageLocatorItemsData result = this._storageItemsFactory.fromDatastoreRawData(rawData);
        return result;
    }

    private Collection<StorageLocatorDatastoreRawData> getAvailableDatastores(ManagedObjectReference resource, Object[] prefetchedResourceDatastores) {
        List<Object> datastores = prefetchedResourceDatastores != null ? Arrays.asList(prefetchedResourceDatastores) : this.getRelevantDatastoresForResource(resource);
        Collection<StorageLocatorDatastoreRawData> rawData = this.getDatastoreData(datastores);
        return VmProvisioningStorageLocatorService.filterAvailableDatastores(rawData);
    }

    private List<Object> getRelevantDatastoresForResource(ManagedObjectReference resource) {
        ResultSet clusterDsResult = this._queryService.select(new String[]{PROPERTY_DATASTORE}).from(new String[]{resource.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)resource).fetch();
        List resourceData = clusterDsResult.getItems();
        if (resourceData.isEmpty() || ((ResourceItem)resourceData.get(0)).get(PROPERTY_DATASTORE) == null) {
            return Collections.emptyList();
        }
        return Arrays.asList((Object[])((ResourceItem)resourceData.get(0)).get(PROPERTY_DATASTORE));
    }

    private Collection<StorageLocatorDatastoreRawData> getDatastoreData(Collection<Object> dsRefs) {
        if (dsRefs == null || dsRefs.isEmpty()) {
            return Collections.emptyList();
        }
        Collection result = this._queryBindingService.prepare(StorageLocatorDatastoreRawData.class).fetch(dsRefs);
        return result;
    }

    private static Collection<StorageLocatorDatastoreRawData> filterAvailableDatastores(Collection<StorageLocatorDatastoreRawData> datastores) {
        ArrayList<StorageLocatorDatastoreRawData> result = new ArrayList<StorageLocatorDatastoreRawData>();
        for (StorageLocatorDatastoreRawData datastore : datastores) {
            if (!VmProvisioningStorageLocatorService.isAvailable(datastore)) continue;
            result.add(datastore);
        }
        return result;
    }

    private static boolean isAvailable(StorageLocatorDatastoreRawData datastore) {
        return datastore.summary != null && datastore.summary.accessible && Datastore.Summary.MaintenanceModeState.normal.toString().equals(datastore.summary.maintenanceMode);
    }
}

