/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.type;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.UserSpecificLsFactory;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CmSsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(CmSsoServiceProviderImpl.class);
    private static final String LS_SSO_SERVICE_CACHE_KEY = "lsSsoServiceCache";
    private final UserSpecificLsFactory _lsFactory;
    private final SsoService _ssoService;

    public CmSsoServiceProviderImpl(UserSpecificLsFactory lsFactory, SsoService ssoService) {
        Validate.notNull((Object)lsFactory);
        Validate.notNull((Object)ssoService);
        this._lsFactory = lsFactory;
        this._ssoService = ssoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent event) throws Exception {
        Map cache = (Map)SessionUtil.removeData((String)LS_SSO_SERVICE_CACHE_KEY, (HttpSession)event.getSession());
        if (cache == null || cache.isEmpty()) {
            return;
        }
        CmSsoServiceProviderImpl cmSsoServiceProviderImpl = this;
        synchronized (cmSsoServiceProviderImpl) {
            for (Map.Entry entry : cache.entrySet()) {
                SsoAdminService service = (SsoAdminService)entry.getValue();
                try {
                    service.logout();
                }
                catch (Exception e) {
                    _logger.error((Object)("Failed to log out of service " + service), (Throwable)e);
                }
            }
        }
        cache.clear();
    }

    public void sessionStarted(HttpSessionEvent event, Locale locale) throws Exception {
    }

    @type(value="cm:Server")
    public SsoAdminService getAdminService(URI serverReference, SsoDomain ssoDomain) throws Exception {
        SsoAdminService svc;
        String id = CmReferenceUtil.getServerId(serverReference);
        Map cache = (Map)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (cache != null && (svc = (SsoAdminService)cache.get(id)) != null) {
            return svc;
        }
        return this.getAdminServiceSynchronized(serverReference);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(URI serverReference) throws Exception {
        ServiceRegistration.Info ssoServiceInfo;
        HashMap existingCache;
        SsoAdminService svc;
        String id = CmReferenceUtil.getServerId(serverReference);
        HashMap cache = (HashMap)SessionUtil.getData((String)LS_SSO_SERVICE_CACHE_KEY);
        if (cache != null && (svc = (SsoAdminService)cache.get(id)) != null) {
            return svc;
        }
        if (cache == null && (existingCache = (HashMap)SessionUtil.setDataIfAbsent((String)LS_SSO_SERVICE_CACHE_KEY, cache = new HashMap())) != null) {
            cache = existingCache;
        }
        if ((ssoServiceInfo = this.findSsoServiceInfo(serverReference)) == null) {
            throw CmUtil.getFault("error.ssoServiceInfoNotFound", serverReference.toString());
        }
        SsoServerInfo serverInfo = this.findSsoServerInfo(ssoServiceInfo);
        SsoAdminService ssoAdminService = SsoUtil.getAdminService((SsoServerInfo)serverInfo, (SsoService)this._ssoService, (SamlToken)AuthSessionUtil.getSsoToken((SsoDomain)serverInfo.getSsoDomain()), (boolean)false);
        cache.put(id, ssoAdminService);
        return ssoAdminService;
    }

    private ServiceRegistration.Info findSsoServiceInfo(URI serverReference) {
        ServiceRegistration.Filter filterCriteria = new ServiceRegistration.Filter();
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setType("com.vmware.cis.cs.identity.admin");
        filterCriteria.setEndpointType(endpointType);
        Object[] allSsoServices = this._lsFactory.getLookupService().getServiceRegistrationInfos(filterCriteria);
        String hostname = CmReferenceUtil.getServerId(serverReference);
        if (hostname == null) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Searching for hostname '" + hostname + "' among " + Arrays.toString(allSsoServices)));
        }
        for (ServiceRegistration.Info si : (ServiceRegistration.Info[])ArrayUtil.toSafe((Object[])allSsoServices, ServiceRegistration.Info.class)) {
            String tempHostname = CmUtil.getServerHostname(si);
            if (!hostname.equals(tempHostname)) continue;
            return si;
        }
        return null;
    }

    private SsoServerInfo findSsoServerInfo(ServiceRegistration.Info serviceInfo) throws Exception {
        ServiceRegistration.Endpoint[] endpoints;
        for (ServiceRegistration.Endpoint ep : endpoints = serviceInfo.getServiceEndpoints()) {
            if (!ep.getEndpointType().getType().equals("com.vmware.cis.cs.identity.admin")) continue;
            String adminAppUrl = ep.getUrl().toString();
            for (Map.Entry mapEntry : this._ssoService.getServerInfos().entrySet()) {
                SsoServerInfo ssoServerInfo = (SsoServerInfo)mapEntry.getValue();
                if (!ssoServerInfo.getAllAdminAppUrls().contains(adminAppUrl)) continue;
                if (ssoServerInfo.getAdminAppUrl().equals(adminAppUrl)) {
                    return ssoServerInfo;
                }
                return this.createServerInfoFromExisting(adminAppUrl, ssoServerInfo);
            }
            throw new Exception(String.format("SsoAdminService endpoint '%s' does not match any of the servers in SsoService.getServerInfos()", adminAppUrl));
        }
        throw new Exception(String.format("Service '%s' is missing any endpoints", serviceInfo.serviceNameDefault));
    }

    private SsoServerInfo createServerInfoFromExisting(String newAdminAppUrl, SsoServerInfo existingServerInfo) throws UnsupportedEncodingException, CertificateException {
        SsoServerInfo.Builder infoBuilder = new SsoServerInfo.Builder();
        infoBuilder.adminAppUrl = newAdminAppUrl;
        infoBuilder.keyStore = existingServerInfo.getKeyStore();
        infoBuilder.ssoDomain = existingServerInfo.getSsoDomain();
        infoBuilder.allStsServerInfos = existingServerInfo.getAllStsServerInfos();
        return infoBuilder.getInstance();
    }
}

