/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.cm.InfrastructureNodeInfo;
import com.vmware.vsphere.client.cm.util.CmAuthorizationService;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.ServerPropertyValueExtractor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectReferencePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ObjectReferencePropertyProvider.class);
    private final DataService _dataService;
    private final SsoService _ssoService;
    private final SsoServiceManager _ssoServiceManager;
    private final CmAuthorizationService _cmAuthorizationService;
    private final ServerPropertyValueExtractor _serverPropertyValueExtractor;
    private final UserSessionService _usService;
    private final LookupService _lookupService;

    public ObjectReferencePropertyProvider(DataService dataService, SsoService ssoService, CmAuthorizationService cmAuthorizationService, UserSessionService usService, ServerPropertyValueExtractor serverPropertyValueExtractor, SsoServiceManager ssoServiceManager, LookupService lookupService) {
        this._lookupService = lookupService;
        this._dataService = dataService;
        this._ssoService = ssoService;
        this._cmAuthorizationService = cmAuthorizationService;
        this._usService = usService;
        this._serverPropertyValueExtractor = serverPropertyValueExtractor;
        this._ssoServiceManager = ssoServiceManager;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:adminServer")
    public URI getAdminServer(URI clientInstance) throws Exception {
        SsoServerInfo serverInfo = this._ssoService.getServerInfo();
        String adminAppUrl = serverInfo.getAdminAppUrl();
        URL adminServiceUrl = new URL(adminAppUrl);
        String ssoHostName = adminServiceUrl.getHost();
        PropertyConstraint magicalConstraint = QueryUtil.createPropertyConstraint((String)"cm:Server", (String)"hostname", (Comparator)Comparator.EQUALS, (Object)ssoHostName);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)magicalConstraint, (String[])new String[]{"cm.service.getAdminServer"});
        ResultSet result = null;
        try {
            result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result != null && result.error != null) {
            _logger.error((Object)result.error.getMessage(), (Throwable)result.error);
        }
        if (result == null || ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            _logger.info((Object)"SSO Admin Server was not found!");
            return null;
        }
        URI scaURI = (URI)result.items[0].resourceObject;
        return scaURI;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:serviceList")
    public URI[] getVsphereServices(URI clientInstance, Object[] serviceIdsByServerGuids) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])serviceIdsByServerGuids) || !this._cmAuthorizationService.isCurrentUserAuthorized()) {
            return new URI[0];
        }
        URI[] result = new URI[serviceIdsByServerGuids.length];
        Map<String, String> hostnamesByGuid = this.getVcHostnamesByGuid();
        for (int i = 0; i < serviceIdsByServerGuids.length; ++i) {
            Pair serviceIdByServerGuid = (Pair)serviceIdsByServerGuids[i];
            Validate.isTrue((!StringUtil.isNullOrEmpty((String)((String)serviceIdByServerGuid.first)) ? 1 : 0) != 0, (String)"Empty service ID in service URI.");
            Validate.isTrue((!StringUtil.isNullOrEmpty((String)((String)serviceIdByServerGuid.second)) ? 1 : 0) != 0, (String)"Empty server guid in service URI.");
            String serviceId = (String)serviceIdByServerGuid.first;
            String hostname = hostnamesByGuid.get(serviceIdByServerGuid.second);
            result[i] = "applmgmt".equalsIgnoreCase(serviceId) ? CmReferenceUtil.getServerReference(hostname) : CmReferenceUtil.getServiceReference(serviceId, hostname);
        }
        return result;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isSysAdminPrivilegeGranted")
    public Boolean getIsSysAdminPrivilegeGranted(URI clientInstance) {
        return this._cmAuthorizationService.isCurrentUserAuthorized();
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:isCaAdminPrivilegeGranted")
    public Boolean getIsCaAdminPrivilegeGranted(URI clientInstance) {
        return this._cmAuthorizationService.isCaAdminsUser();
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:activeDirectoryInfo")
    public Object getActiveDirectoryInfo(URI clientInstance, InfrastructureNodeInfo serverInfo) {
        InternalServerInfo internalServerInfo = new InternalServerInfo(serverInfo.getHostname(), serverInfo.getDomainController());
        return this._serverPropertyValueExtractor.getValues(new InternalServerInfo[]{internalServerInfo}, new String[]{"activeDirectoryInfo"})[0];
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:infrastructureNodes")
    public Collection<InfrastructureNodeInfo> getSsoNodes(URI clientInstance) throws Exception {
        ArrayList<InfrastructureNodeInfo> ssoServers = new ArrayList<InfrastructureNodeInfo>();
        Collection<InternalServerInfo> servers = CmUtil.getServers(this._ssoServiceManager);
        for (InternalServerInfo serverInfo : servers) {
            if (!serverInfo.isDomainController()) continue;
            InfrastructureNodeInfo server = new InfrastructureNodeInfo();
            server.setHostname(serverInfo.getHostname());
            server.setDomainController(serverInfo.isDomainController());
            server.setEncodedHostname(serverInfo.getHostname());
            ssoServers.add(server);
        }
        return ssoServers;
    }

    @ModelMetadata(type={"vsphere:vSphereClientInstance"}, property="vsphere:loggedInVCenter")
    public String getLoggedInVCenter(URI clientInstance) throws Exception {
        String hostId = LookupUtil.getLocalHostId((LookupService)this._lookupService);
        if (hostId == null) {
            return null;
        }
        ServiceRegistration.ServiceType vcServiceType = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(vcServiceType);
        ServiceRegistration.Info[] vcServiceInfos = null;
        vcServiceInfos = this._lookupService.getServiceRegistrationInfos(filter);
        if (vcServiceInfos != null) {
            for (ServiceRegistration.Info info : vcServiceInfos) {
                String serviceHostId = LookupUtil.getServiceHostId((ServiceRegistration.Info)info);
                if (!hostId.equals(serviceHostId) || info.serviceEndpoints[0] == null) continue;
                return info.serviceEndpoints[0].getUrl().getHost();
            }
        }
        return null;
    }

    private Map<String, String> getVcHostnamesByGuid() {
        ServerInfo[] serverInfos = this._usService.getUserSession().serversInfo;
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (ServerInfo si : serverInfos) {
            result.put(si.serviceGuid, si.name);
        }
        return result;
    }
}

