/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vapi.std.errors.Error;
import com.vmware.vim.binding.sso.admin.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.PowerOperationConfig;
import com.vmware.vise.vim.security.certificates.PasswordVerifySpec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ServerActiveDirectorySpec;
import com.vmware.vsphere.client.cm.ServerEditAccessSpec;
import com.vmware.vsphere.client.cm.ServerEditFirewallSpec;
import com.vmware.vsphere.client.cm.ServerEditNetworkingSpec;
import com.vmware.vsphere.client.cm.ServerOperationSpec;
import com.vmware.vsphere.client.cm.ServersEditSpec;
import com.vmware.vsphere.client.cm.util.ApplmgmtServiceRegistry;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServersMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ServersMutationProvider.class);
    private final ApplmgmtServiceRegistry _applmgmtRegistry;
    private final VmcaService _vmcaService;
    private SsoServiceManager _ssoServiceManager;

    public ServersMutationProvider(ApplmgmtServiceRegistry applmgmtRegistry, VmcaService vmcaService) {
        this._applmgmtRegistry = applmgmtRegistry;
        this._vmcaService = vmcaService;
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public OperationResult apply(URI target, ServerOperationSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Validate.notNull((Object)((Object)spec), (String)"The spec must not be null");
            result.entity = target;
            CloudVmService applmgmt = this._applmgmtRegistry.getCloudVmService(CmReferenceUtil.getServerId(target));
            PowerOperationConfig powerOpConfig = ServersMutationProvider.getPowerOpConfig(spec);
            ServerOperationSpec.Operation op = spec.operation;
            switch (op) {
                case RESTART: {
                    applmgmt.restart(powerOpConfig);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown server operation: " + (Object)((Object)op));
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    public OperationResult apply(URI target, ServersEditSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Validate.notNull((Object)((Object)spec), (String)"The spec must not be null");
            CloudVmService service = this._applmgmtRegistry.getCloudVmService(CmReferenceUtil.getServerId(target));
            this.setAccessSpec(service, spec.accessSpec);
            this.setNetworkingSpec(service, spec.netSpec);
            this.setFirewallSpec(service, spec.firewallSpec);
            result.entity = target;
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    public OperationResult apply(URI target, PasswordVerifySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            Validate.notNull((Object)spec, (String)"The spec must not be null");
            String serverName = CmReferenceUtil.getServerId(target);
            String password = spec.password;
            String user = spec.user;
            String domain = spec.domain;
            this._vmcaService.createVmcaClient(serverName, user, password, domain);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = ServersMutationProvider.getMethodFault(e);
            result.parameter = false;
        }
        return result;
    }

    private void setAccessSpec(CloudVmService service, ServerEditAccessSpec accessSpec) throws CloudVmServiceException {
        if (accessSpec == null) {
            return;
        }
        if (accessSpec.isConsoleCliEndabled != null) {
            service.setConsoleCliEnabled(accessSpec.isConsoleCliEndabled.booleanValue());
        }
        if (accessSpec.shellEnabledConfig != null) {
            service.setShellConfig(accessSpec.shellEnabledConfig);
        }
        if (accessSpec.isSshEndabled != null) {
            service.setSshEnabled(accessSpec.isSshEndabled.booleanValue());
        }
    }

    private void setNetworkingSpec(CloudVmService service, ServerEditNetworkingSpec spec) throws CloudVmServiceException {
        if (spec == null) {
            return;
        }
        if (spec.hostname != null) {
            service.setHostname(spec.hostname);
        }
        if (spec.domains != null) {
            service.setDnsDomains(spec.domains);
        }
        if (spec.dnsConfig != null) {
            service.setDnsServersConfig(spec.dnsConfig);
        }
        if (spec.ipv4Config != null && spec.ipv4Config.length > 0) {
            for (IPv4Config ipv4CfgSpec : spec.ipv4Config) {
                if (ipv4CfgSpec.address == null) {
                    ipv4CfgSpec.address = "";
                }
                if (ipv4CfgSpec.defaultGateway != null) continue;
                ipv4CfgSpec.defaultGateway = "";
            }
            service.setIPv4Config(spec.ipv4Config);
        }
        if (spec.ipv6Config != null && spec.ipv6Config.length > 0) {
            service.setIPv6Config(spec.ipv6Config);
        }
    }

    private void setFirewallSpec(CloudVmService service, ServerEditFirewallSpec spec) throws CloudVmServiceException {
        if (spec == null) {
            return;
        }
        if (spec.rules != null) {
            service.setFirewallRules(spec.rules);
        }
    }

    public OperationResult apply(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = null;
        result = !StringUtil.isNullOrEmpty((String)spec.domain) ? this.joinActiveDirectory(target, spec) : this.leaveActiveDirectory(target, spec);
        return result;
    }

    private OperationResult joinActiveDirectory(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            SsoAdminService adminService = this._ssoServiceManager.getAdminService((Object)target, SsoDomain.getLocal());
            SystemManagementService systemMgmt = adminService.getSystemManagementService();
            systemMgmt.joinActiveDirectory(spec.username, spec.password, spec.domain, spec.organizationalUnit);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error joining Active Directory for %s", CmReferenceUtil.getServerId(target)), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    private OperationResult leaveActiveDirectory(URI target, ServerActiveDirectorySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = target;
        try {
            SsoAdminService adminService = this._ssoServiceManager.getAdminService((Object)target, SsoDomain.getLocal());
            SystemManagementService systemMgmt = adminService.getSystemManagementService();
            systemMgmt.leaveActiveDirectory(spec.username, spec.password);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error leaving Active Directory for %s", CmReferenceUtil.getServerId(target)), (Throwable)e);
            result.error = ServersMutationProvider.getMethodFault(e);
        }
        return result;
    }

    private static PowerOperationConfig getPowerOpConfig(ServerOperationSpec spec) {
        PowerOperationConfig result = new PowerOperationConfig();
        result.reason = spec.reason;
        result.delay = -1L;
        return result;
    }

    private static MethodFault getMethodFault(Exception e) {
        Throwable cause;
        if (e == null) {
            return null;
        }
        if (e instanceof MethodFault) {
            return (MethodFault)e;
        }
        if (e instanceof Error) {
            return CmUtil.transformVapiError((Error)e);
        }
        if (e instanceof InvocationTargetException && (cause = e.getCause()) != null && cause != e && cause instanceof Exception) {
            return ServersMutationProvider.getMethodFault((Exception)cause);
        }
        MethodFault result = new MethodFault(e.getMessage());
        result.initCause((Throwable)e);
        return result;
    }
}

